/*
 * Decompiled with CFR 0.152.
 */
package misc.script.helping;

import com.corelationinc.script.Report;
import com.corelationinc.script.Script;
import com.corelationinc.script.utils.CSV.CSVWriter;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class VelocityExport {
    Script script = null;

    public static void runScript(Script script) throws Exception {
        VelocityExport test = new VelocityExport(script);
        test.run();
    }

    private VelocityExport(Script value) {
        this.script = value;
    }

    private void run() throws Exception {
        Connection connection = this.script.openDatabaseConnection();
        Report exportReport = this.script.openReport("Velocity Export", Report.Format.txt);
        PrintStream os = new PrintStream(exportReport.getBufferedOutputStream());
        os.println("POSTING_DATE,ACCOUNT_NUMBER,PRIMARY_NAME,JOINT_NAME,SHARE_JOINT_CATEGORY,STREET,CITY,STATE,POSTAL_CODE,MAIL_CODE,PRODUCT_CODE,STATUS_CODE,PREVIOUS_MONTH_MONETARY_COUNT,CURRENT_YEAR_MONETARY_COUNT,PREVIOUS_YEAR_MONETARY_COUNT,OD_LIMIT,PHONE,EMAIL,OPEN_DATE,CLOSE_DATE,CURRENT_BALANCE,AVERAGE_BALANCE,CURRENT_RATE,PREVIOUS_MONTH_INTEREST_PAID,PREVIOUS_CP_FEE,PREVIOUS_OTHER_FEES,PRIMARY_SOCIAL,JOINT_SOCIAL,PRIMARY_BIRTH_DATE,JOINT_BIRTH_DATE,REG_D_PAY");
        String sql = "  WITH CurrentAddress(personSerial, street, additionalAddressLine, city, state, postalCode, combinedAddress) AS (      SELECT          PERSON_SERIAL,          COALESCE(ADDRESS.STREET, '') AS STREET,          COALESCE(ADDRESS.ADDITIONAL_ADDRESS_LINE, '') AS ADDITIONAL_ADDRESS_LINE,          COALESCE(ADDRESS.CITY, '') AS CITY,          COALESCE(ADDRESS.STATE, '') AS STATE,          COALESCE(ADDRESS.POSTAL_CODE, '') AS POSTAL_CODE,          COALESCE(ADDRESS.STREET || ' ', '') || COALESCE(ADDRESS.ADDITIONAL_ADDRESS_LINE || ', ', '') ||          COALESCE(ADDRESS.CITY || ' ', '') || COALESCE(ADDRESS.STATE, '') || COALESCE(', ' || ADDRESS.POSTAL_CODE, '') AS COMBINED_ADDRESS      FROM      (          SELECT              PAL.PARENT_SERIAL AS PERSON_SERIAL,              PAL.ADDRESS_SERIAL AS ADDRESS_SERIAL,              COALESCE(PAL.ORDINAL, 0) AS PAL_ORDINAL,              MIN(COALESCE(PAL.ORDINAL, 0)) OVER (PARTITION BY PAL.PARENT_SERIAL) AS MIN_PAL_ORDINAL          FROM              CORE.PERSON_ADDRESS_LINK AS PAL LEFT OUTER JOIN              CORE.ENV AS ENV ON                  ENV.SERIAL > 0          WHERE              (PAL.EFFECTIVE_DATE IS NULL OR              PAL.EFFECTIVE_DATE <= ENV.POSTING_DATE) AND              (PAL.EXPIRATION_DATE IS NULL OR              PAL.EXPIRATION_DATE >= ENV.POSTING_DATE) AND              PAL.BAD_ADDRESS <> 'Y' AND              PAL.CATEGORY <> 'V'      ) LEFT OUTER JOIN          CORE.ADDRESS AS ADDRESS ON              ADDRESS_SERIAL = ADDRESS.SERIAL AND ADDRESS.ADDRESS_FORMAT = 'D'      WHERE          PAL_ORDINAL = MIN_PAL_ORDINAL  ),  CurrentEmail(personSerial, email) AS (      SELECT          PERSON_CONTACT.PARENT_SERIAL AS PERSON_SERIAL,          PERSON_CONTACT.VALUE      FROM          CORE.PERSON_CONTACT AS PERSON_CONTACT       WHERE          PERSON_CONTACT.CATEGORY IN ('PE','BE') AND          PERSON_CONTACT.BAD_CONTACT = 'N' AND          NOT EXISTS (SELECT 1                       FROM                          CORE.PERSON_CONTACT AS PERSON_CONTACT_INNER                      WHERE                          PERSON_CONTACT_INNER.PARENT_SERIAL = PERSON_CONTACT.PARENT_SERIAL AND                          PERSON_CONTACT_INNER.ORDINAL > PERSON_CONTACT.ORDINAL AND                          PERSON_CONTACT.CATEGORY IN ('PE','BE') AND                          PERSON_CONTACT.BAD_CONTACT = 'N')   ),  CurrentPhone(personSerial, phone) AS (      SELECT          PERSON_CONTACT.PARENT_SERIAL AS PERSON_SERIAL,          PERSON_CONTACT.VALUE      FROM          CORE.PERSON_CONTACT AS PERSON_CONTACT       WHERE          PERSON_CONTACT.CATEGORY IN ('HP','BP') AND          PERSON_CONTACT.BAD_CONTACT = 'N' AND          NOT EXISTS (SELECT 1                       FROM                          CORE.PERSON_CONTACT AS PERSON_CONTACT_INNER                      WHERE                          PERSON_CONTACT_INNER.PARENT_SERIAL = PERSON_CONTACT.PARENT_SERIAL AND                          PERSON_CONTACT_INNER.ORDINAL > PERSON_CONTACT.ORDINAL AND                          PERSON_CONTACT.CATEGORY IN ('HP','BP') AND                          PERSON_CONTACT.BAD_CONTACT = 'N')   ),  DefaultDates (StartDate, EndDate) AS (      SELECT          ENV.POSTING_DATE - DAY(ENV.POSTING_DATE)DAYS + 1 DAYS - 1 MONTH,          ENV.POSTING_DATE - DAY(ENV.POSTING_DATE)DAYS      FROM      CORE.ENV AS ENV  ),     SelectedShares (Serial, OpenDate, CloseDate, TmpStartDate, TmpEndDate) AS (      SELECT          SHARE.SERIAL AS SHARE_SERIAL,          SHARE.OPEN_DATE AS OPEN_DATE ,          SHARE.CLOSE_DATE AS CLOSE_DATE,          GREATEST(SHARE.OPEN_DATE, DefaultDates.StartDate) AS TMP_STARTDATE,          LEAST(COALESCE(SHARE.CLOSE_DATE - 1 Day, SHARE.CHARGE_OFF_DATE - 1 Day, DefaultDates.EndDate), DefaultDates.EndDate) AS TMP_ENDDATE      FROM          CORE.SHARE AS SHARE,          DefaultDates      WHERE          SHARE.OPEN_DATE <= DefaultDates.EndDate AND          COALESCE(SHARE.CLOSE_DATE, DefaultDates.StartDate + 1 Day) > DefaultDates.StartDate AND          COALESCE(SHARE.CHARGE_OFF_DATE, DefaultDates.StartDate + 1 Day) > DefaultDates.StartDate  ),   AverageBalance(storedAccessKey, averageBalance) AS (      SELECT          STORED_ACCESS_KEY,          CASE              WHEN DAYS_IN_PERIOD = 0 THEN 0              ELSE CAST(FLOAT(BAL_DAYS) / DAYS_IN_PERIOD + 0.005 AS DECIMAL(16,2))          END AS AVG_BAL      FROM (          SELECT              STORED_ACCESS_KEY,              ACCT,              START_DATE,              END_DATE,              DAYS(END_DATE) - DAYS(START_DATE) + 1 AS DAYS_IN_PERIOD,              SUM(BAL_DAYS) AS BAL_DAYS          FROM (              SELECT                  SHARE.STORED_ACCESS_KEY AS STORED_ACCESS_KEY,                  ACCOUNT.ACCOUNT_NUMBER || ' S ' || SHARE.ID AS ACCT,                  SelectedShares.TmpStartDate AS START_DATE,                  SelectedShares.TmpEndDate AS END_DATE,                  0.00 AS BAL_CHANGE,                  SHARE.BALANCE * (DAYS(SelectedShares.TmpEndDate) - DAYS(SelectedShares.TmpStartDate) + 1) AS BAL_DAYS              FROM                  CORE.SHARE AS SHARE INNER JOIN                  SelectedShares ON                      SHARE.SERIAL = SelectedShares.Serial INNER JOIN                  CORE.ACCOUNT AS ACCOUNT ON                      SHARE.PARENT_SERIAL = ACCOUNT.SERIAL            UNION ALL                 SELECT                  SHARE.STORED_ACCESS_KEY AS STORED_ACCESS_KEY,                  ACCOUNT.ACCOUNT_NUMBER || ' S ' || SHARE.ID AS ACCT,                  SelectedShares.TmpStartDate AS START_DATE,                  SelectedShares.TmpEndDate AS END_DATE,                  MONETARY.PRINCIPAL AS BAL_CHANGE,                  -MONETARY.PRINCIPAL * LEAST(DAYS(MONETARY.EFFECTIVE_DATE) - DAYS(SelectedShares.TmpStartDate),                  DAYS(SelectedShares.TmpEndDate) - DAYS(SelectedShares.TmpStartDate) + 1) AS BAL_DAYS              FROM                  CORE.SHARE AS SHARE INNER JOIN                  SelectedShares ON                      SHARE.SERIAL = SelectedShares.Serial INNER JOIN                  CORE.ACCOUNT AS ACCOUNT ON                      SHARE.PARENT_SERIAL = ACCOUNT.SERIAL INNER JOIN                  CORE.MONETARY AS MONETARY ON                      MONETARY.TARGET_ACCESS_KEY = SHARE.STORED_ACCESS_KEY AND                      MONETARY.POSTING_DATE > SelectedShares.TmpStartDate              WHERE                  MONETARY.STATUS = 'P' AND                  MONETARY.PRINCIPAL <> 0.00          )      GROUP BY          STORED_ACCESS_KEY,          ACCT,          START_DATE,          END_DATE,          DAYS(END_DATE) - DAYS(START_DATE) + 1      )  ),  LastActivityDate(accountSerial,date) AS (  SELECT  \t\tSERIAL,  \t\tMAX(LAST_ACTIVITY_DATE) AS LAST_ACTIVITY_DATE  \tFROM  \t(  \t\tSELECT  \t\t    ACCOUNT.SERIAL,  \t\t    MAX(SHARE.LAST_ACTIVITY_DATE) AS LAST_ACTIVITY_DATE  \t\tFROM  \t\t    CORE.ACCOUNT AS ACCOUNT INNER JOIN  \t\t    CORE.SHARE AS SHARE ON  \t\t        ACCOUNT.SERIAL = SHARE.PARENT_SERIAL  \t\tGROUP BY  \t\t    ACCOUNT.SERIAL  \t\t      \t\tUNION ALL  \t\t  \t\tSELECT  \t\t    ACCOUNT.SERIAL,  \t\t    MAX(LAST_ACTIVITY_DATE) AS LAST_ACTIVITY_DATE  \t\tFROM  \t\t    CORE.ACCOUNT AS ACCOUNT INNER JOIN  \t\t    CORE.LOAN AS LOAN ON  \t\t        ACCOUNT.SERIAL = LOAN.PARENT_SERIAL  \t\tGROUP BY  \t\t    ACCOUNT.SERIAL  \t)      \tGROUP BY  \t\tSERIAL  \tORDER BY  \t\tSERIAL  ),  DividendRate(serial, parentSerial, targetAccessKey, divRate, APY) AS (  SELECT  \tSERIAL,  \tPARENT_SERIAL,      STORED_ACCESS_KEY,      DIV_RATE,  CASE      WHEN DIV_RATE IS NULL OR DIV_RATE = 0 THEN 0      ELSE CAST(ROUND(100*(POWER((1+DECFLOAT(DIV_RATE)/36500),365)-1),2) AS DECIMAL(10,5))      END AS APY  FROM  (      SELECT      \tSHARE.SERIAL,      \tSHARE.PARENT_SERIAL,          SHARE.STORED_ACCESS_KEY,          CASE              WHEN DIV_CALC.RATE_OPTION = 'SFR' THEN DIV_CALC.SINGLE_FIXED_RATE              WHEN DIV_CALC.RATE_OPTION = 'SCR' THEN SHARE.DIVIDEND_CUSTOM_RATE              WHEN DIV_CALC.RATE_OPTION = 'PTR' AND PERSON_RELATIONSHIP_DIV_CALC_RANGE.RATE IS NOT NULL THEN PERSON_RELATIONSHIP_DIV_CALC_RANGE.RATE              WHEN DIV_CALC.RATE_OPTION = 'PTR' AND ACCOUNT_RELATIONSHIP_DIV_CALC_RANGE.RATE IS NOT NULL THEN ACCOUNT_RELATIONSHIP_DIV_CALC_RANGE.RATE              WHEN DIV_CALC.RATE_OPTION = 'PTR' AND NO_RELATIONSHIP_DIV_CALC_RANGE.RATE IS NOT NULL THEN NO_RELATIONSHIP_DIV_CALC_RANGE.RATE              WHEN DIV_CALC.RATE_OPTION = 'STR' AND PERSON_RELATIONSHIP_DIV_CALC_RANGE.RATE IS NOT NULL THEN PERSON_RELATIONSHIP_DIV_CALC_RANGE.RATE              WHEN DIV_CALC.RATE_OPTION = 'STR' AND ACCOUNT_RELATIONSHIP_DIV_CALC_RANGE.RATE IS NOT NULL THEN ACCOUNT_RELATIONSHIP_DIV_CALC_RANGE.RATE              WHEN DIV_CALC.RATE_OPTION = 'STR' AND NO_RELATIONSHIP_DIV_CALC_RANGE.RATE IS NOT NULL THEN NO_RELATIONSHIP_DIV_CALC_RANGE.RATE                                           ELSE 0          END AS DIV_RATE      FROM          CORE.SHARE AS SHARE INNER JOIN          CORE.ACCOUNT AS ACCOUNT ON              ACCOUNT.SERIAL = SHARE.PARENT_SERIAL INNER JOIN          CORE.PERSON AS PERSON ON              PERSON.SERIAL = ACCOUNT.PRIMARY_PERSON_SERIAL LEFT OUTER JOIN          CORE.DIV_CALC AS DIV_CALC ON              SHARE.DIVIDEND_CALCULATION_SERIAL = DIV_CALC.SERIAL LEFT OUTER JOIN          CORE.DIV_CALC_RANGE AS PERSON_RELATIONSHIP_DIV_CALC_RANGE ON              PERSON_RELATIONSHIP_DIV_CALC_RANGE.PARENT_SERIAL = DIV_CALC.SERIAL AND              PERSON_RELATIONSHIP_DIV_CALC_RANGE.RELATIONSHIP_SERIAL IS NOT NULL AND                  PERSON.RELATIONSHIP_SERIAL = PERSON_RELATIONSHIP_DIV_CALC_RANGE.RELATIONSHIP_SERIAL AND              SHARE.BALANCE >= PERSON_RELATIONSHIP_DIV_CALC_RANGE.BALANCE AND          NOT EXISTS (SELECT 1 FROM                                  CORE.DIV_CALC_RANGE AS HIGHER_BAL_DIV_CALC_RANGE                               WHERE                                  HIGHER_BAL_DIV_CALC_RANGE.PARENT_SERIAL = DIV_CALC.SERIAL AND                                  HIGHER_BAL_DIV_CALC_RANGE.RELATIONSHIP_SERIAL = PERSON.RELATIONSHIP_SERIAL AND                                  SHARE.BALANCE >= HIGHER_BAL_DIV_CALC_RANGE.BALANCE AND                                  HIGHER_BAL_DIV_CALC_RANGE.BALANCE > PERSON_RELATIONSHIP_DIV_CALC_RANGE.BALANCE) LEFT OUTER JOIN           CORE.DIV_CALC_RANGE AS ACCOUNT_RELATIONSHIP_DIV_CALC_RANGE ON              ACCOUNT_RELATIONSHIP_DIV_CALC_RANGE.PARENT_SERIAL = DIV_CALC.SERIAL AND              ACCOUNT_RELATIONSHIP_DIV_CALC_RANGE.RELATIONSHIP_SERIAL IS NOT NULL AND              ACCOUNT.RELATIONSHIP_SERIAL = ACCOUNT_RELATIONSHIP_DIV_CALC_RANGE.RELATIONSHIP_SERIAL AND              SHARE.BALANCE >= ACCOUNT_RELATIONSHIP_DIV_CALC_RANGE.BALANCE AND              NOT EXISTS (SELECT 1 FROM                          CORE.DIV_CALC_RANGE AS HIGHER_BAL_DIV_CALC_RANGE                          WHERE                              HIGHER_BAL_DIV_CALC_RANGE.PARENT_SERIAL = DIV_CALC.SERIAL AND                              HIGHER_BAL_DIV_CALC_RANGE.RELATIONSHIP_SERIAL = PERSON.RELATIONSHIP_SERIAL AND                              SHARE.BALANCE >= HIGHER_BAL_DIV_CALC_RANGE.BALANCE AND                              HIGHER_BAL_DIV_CALC_RANGE.BALANCE > ACCOUNT_RELATIONSHIP_DIV_CALC_RANGE.BALANCE) LEFT OUTER JOIN                    CORE.DIV_CALC_RANGE AS NO_RELATIONSHIP_DIV_CALC_RANGE ON                      NO_RELATIONSHIP_DIV_CALC_RANGE.PARENT_SERIAL = DIV_CALC.SERIAL AND                      NO_RELATIONSHIP_DIV_CALC_RANGE.RELATIONSHIP_SERIAL IS NULL AND                  SHARE.BALANCE >= NO_RELATIONSHIP_DIV_CALC_RANGE.BALANCE  AND                  NOT EXISTS (SELECT 1 FROM                                          CORE.DIV_CALC_RANGE AS HIGHER_BAL_DIV_CALC_RANGE                                       WHERE                                          HIGHER_BAL_DIV_CALC_RANGE.PARENT_SERIAL = DIV_CALC.SERIAL AND                                          HIGHER_BAL_DIV_CALC_RANGE.BALANCE > NO_RELATIONSHIP_DIV_CALC_RANGE.BALANCE AND                                          SHARE.BALANCE >= HIGHER_BAL_DIV_CALC_RANGE.BALANCE AND                                          HIGHER_BAL_DIV_CALC_RANGE.RELATIONSHIP_SERIAL IS NULL)              )    ),  CTEMonetary(targetAccesskey, currentMonth, previousMonth, currentYear, previousYear) AS (  SELECT  \tTARGET_ACCESS_KEY AS TARGET_ACCESS_KEY,  \tCOUNT(CURRENT_MONTH) AS CURRENT_MONTH,  \tCOUNT(PREVIOUS_MONTH) AS PREVIOUS_MONTH,  \tCOUNT(CURRENT_YEAR) AS CURRENT_YEAR,  \tCOUNT(PREVIOUS_YEAR) AS PREVIOUS_YEAR  FROM  (  SELECT  \tMONETARY.TARGET_ACCESS_KEY AS TARGET_ACCESS_KEY,  \tCASE  \tWHEN MONETARY.POSTING_DATE BETWEEN ENV.POSTING_DATE - DAY(ENV.POSTING_DATE) DAYS + 1 DAY AND ENV.POSTING_DATE THEN MONETARY.PRINCIPAL  \tEND AS CURRENT_MONTH,  \tCASE  \tWHEN MONETARY.POSTING_DATE BETWEEN (ENV.POSTING_DATE - DAY(ENV.POSTING_DATE)DAYS + 1 DAYS - 1 MONTH) AND (ENV.POSTING_DATE - DAY(ENV.POSTING_DATE)DAYS) THEN MONETARY.PRINCIPAL  \tEND AS PREVIOUS_MONTH,  \tCASE  \tWHEN YEAR(MONETARY.POSTING_DATE) = YEAR(ENV.POSTING_DATE) THEN MONETARY.PRINCIPAL  \tEND AS CURRENT_YEAR,  \tCASE  \tWHEN YEAR(MONETARY.POSTING_DATE) = YEAR(ENV.POSTING_DATE - 1 YEAR) THEN MONETARY.PRINCIPAL  \tEND AS PREVIOUS_YEAR\t  FROM  \tCORE.ENV AS ENV CROSS JOIN  \tCORE.MONETARY AS MONETARY  WHERE  \tMONETARY.STATUS = 'P' AND  \tMONETARY.CATEGORY = 'W' AND  \tMONETARY.DESCRIPTION NOT LIKE 'Insufficient %' AND  \tMONETARY.DESCRIPTION NOT LIKE 'Overdraft T%' AND      MONETARY.DESCRIPTION NOT LIKE 'Courtesy %' AND      (EXISTS ( SELECT 1      \t\t\t FROM CORE.TRANSACTION AS TRANSACTION INNER JOIN      \t\t\t \t  CORE.TRANSACTION_RESULT AS TRANS_RESULT ON      \t\t\t \t  TRANSACTION.SERIAL = TRANS_RESULT.PARENT_SERIAL      \t\t\t WHERE      \t\t\t \t  TRANSACTION.SERIAL = MONETARY.PARENT_SERIAL AND      \t\t\t \t  TRANS_RESULT.DESCRIPTION LIKE 'Withdrawal below %')      \tOR      \tEXISTS ( SELECT 1      \t         FROM CORE.MON_DETAIL AS INNER_MON_DETAIL      \t         WHERE      \t         \t  MONETARY.SERIAL = INNER_MON_DETAIL.PARENT_SERIAL AND      \t         \t  INNER_MON_DETAIL.CATEGORY = 'OCP' AND  \t   \t         \t  INNER_MON_DETAIL.CONTENTS_2 = 'Y'))  )  GROUP BY  \tTARGET_ACCESS_KEY  ),  MonetaryFee(targetAccesskey, currentCPFee, currentOtherFees, previousCPFee, previousOtherFees) AS (  SELECT  \tTARGET_ACCESS_KEY,  \tSUM(CURRENT_CP_FEE) AS CURRENT_CP_FEE,  \tSUM(CURRENT_OTHER_FEES) AS CURRENT_OTHER_FEES,  \tSUM(PREVIOUS_CP_FEE) AS PREVIOUS_CP_FEE,  \tSUM(PREVIOUS_OTHER_FEES) AS PREVIOUS_OTHER_FEES  FROM  (  SELECT  \tMONETARY.TARGET_ACCESS_KEY AS TARGET_ACCESS_KEY,  \tCASE  \t\tWHEN MONETARY.DESCRIPTION LIKE 'Courtesy %' AND MONETARY.POSTING_DATE BETWEEN ENV.POSTING_DATE - DAY(ENV.POSTING_DATE) DAYS + 1 DAY AND ENV.POSTING_DATE THEN MONETARY.PRINCIPAL  \t\tEND AS CURRENT_CP_FEE,  \tCASE  \t\tWHEN MONETARY.DESCRIPTION NOT LIKE 'Courtesy %' AND MONETARY.POSTING_DATE BETWEEN ENV.POSTING_DATE - DAY(ENV.POSTING_DATE) DAYS + 1 DAY AND ENV.POSTING_DATE  THEN MONETARY.PRINCIPAL  \t\tEND AS CURRENT_OTHER_FEES,  \tCASE  \t\tWHEN MONETARY.DESCRIPTION LIKE 'Courtesy %' AND MONETARY.POSTING_DATE BETWEEN (ENV.POSTING_DATE - DAY(ENV.POSTING_DATE)DAYS + 1 DAYS - 1 MONTH) AND (ENV.POSTING_DATE - DAY(ENV.POSTING_DATE)DAYS) THEN MONETARY.PRINCIPAL  \t\tEND AS PREVIOUS_CP_FEE,  \tCASE\t  \t\tWHEN MONETARY.DESCRIPTION NOT LIKE 'Courtesy %' AND MONETARY.POSTING_DATE BETWEEN (ENV.POSTING_DATE - DAY(ENV.POSTING_DATE)DAYS + 1 DAYS - 1 MONTH) AND (ENV.POSTING_DATE - DAY(ENV.POSTING_DATE)DAYS) THEN MONETARY.PRINCIPAL  \t\tEND AS PREVIOUS_OTHER_FEES  FROM  \tCORE.ENV AS ENV CROSS JOIN  \tCORE.MONETARY AS MONETARY  WHERE  \tMONETARY.STATUS = 'P' AND  \tMONETARY.CATEGORY = 'W' AND  \tMONETARY.SOURCE = 'F'  )  GROUP BY  \tTARGET_ACCESS_KEY  )  SELECT      TO_CHAR(ENV.POSTING_DATE, 'MM/DD/YYYY') AS POSTING_DATE,  \tACCOUNT.ACCOUNT_NUMBER || ' S ' || SHARE.ID AS ACCOUNT_NUMBER,  \tPERSON.LAST_NAME || COALESCE(',' || PERSON.FIRST_NAME, '') AS PRIMARY_NAME,  \tSHARE_JOINT.LAST_NAME || COALESCE(',' || SHARE_JOINT.FIRST_NAME, '') AS JOINT_NAME,  \tCASE SH_PERSON_LINK.CATEGORY  \tWHEN 'JT' THEN 'Joint owner'  \tWHEN 'AS' THEN 'Authorized signer'  \tWHEN 'PA' THEN 'Power of attorney'  \tWHEN 'TR' THEN 'Trustee'  \tWHEN 'CU' THEN 'Custodian'  \tWHEN 'GD' THEN 'Guardian'  \tWHEN 'CV' THEN 'Conservator'  \tWHEN 'RP' THEN 'Representative payee'  \tWHEN 'VF' THEN 'VA fiduciary'  \tWHEN 'AD' THEN 'Administrator'  \tWHEN 'EX' THEN 'Executor'  \tWHEN 'ST' THEN 'Successor trustee'  \tWHEN 'SC' THEN 'Successor custodian'  \tWHEN 'SR' THEN 'Settlor'  \tWHEN 'BE' THEN 'Beneficiary'  \tWHEN 'BC' THEN 'Contingent beneficiary'  \tWHEN 'RB' THEN 'Revocable trust beneficiary'  \tWHEN 'RC' THEN 'Contingent revocable trust beneficiary'  \tWHEN 'IB' THEN 'Irrevocable trust beneficiary'  \tWHEN 'IC' THEN 'Contingent irrevocable trust beneficiary'  \tWHEN 'AU' THEN 'Authorized user'  \tWHEN 'BO' THEN 'Beneficial owner'  \tWHEN 'CP' THEN 'Control person'  \tWHEN 'AA' THEN 'Additional mailing addressee'  \tWHEN 'OT' THEN 'Other related party'  \tEND AS SHARE_JOINT_CATEGORY,  \tCurrentAddress.street || COALESCE ((', ') || CurrentAddress.additionalAddressLine, '') AS STREET,      CurrentAddress.city AS CITY,   \tCurrentAddress.state AS STATE,   \tCurrentAddress.postalCode AS POSTAL_CODE,  \tCASE ACCOUNT.E_STMT_NOTIFICATION  \tWHEN 'N' THEN 'No'  \tWHEN 'Y' THEN 'Yes'  \tEND AS MAIL_CODE,  \tSH_TYPE.SERIAL AS PRODUCT_CODE,\t  \tCASE  \tWHEN DAYS(ENV.POSTING_DATE) - DAYS(LastActivityDate.date) <= '90' THEN 'ACTIVE'  \tWHEN DAYS(ENV.POSTING_DATE) - DAYS(LastActivityDate.date) BETWEEN '90' AND '180' THEN 'INACTIVE'  \tWHEN DAYS(ENV.POSTING_DATE) - DAYS(LastActivityDate.date) >= '180' THEN 'DORMANT'   \tEND AS STATUS_CODE,   \tCTEMonetary.previousMonth AS PREVIOUS_MONTH_MONETARY_COUNT,  \tCTEMonetary.currentYear AS CURRENT_YEAR_MONETARY_COUNT,   \tCTEMonetary.previousYear AS PREVIOUS_YEAR_MONETARY_COUNT,  \tSHARE.COURTESY_PAY_LIMIT AS OD_LIMIT,  \tCurrentPhone.phone AS PHONE,  \tCurrentEmail.email AS EMAIL,   \t  \tSHARE.OPEN_DATE AS OPEN_DATE,  \tSHARE.CLOSE_DATE AS CLOSE_DATE,  \tSHARE.BALANCE AS CURRENT_BALANCE,  \tAverageBalance.averageBalance AS AVERAGE_BALANCE,  \tDividendRate.divRate AS CURRENT_RATE,  \tCASE  \tWHEN SHARE.DIVIDEND_LAST_DATE BETWEEN (ENV.POSTING_DATE - DAY(ENV.POSTING_DATE)DAYS + 1 DAYS - 1 MONTH) AND (ENV.POSTING_DATE - DAY(ENV.POSTING_DATE)DAYS) THEN SHARE.DIVIDEND_LAST_AMOUNT  \tELSE 0.00  \tEND AS PREVIOUS_MONTH_INTEREST_PAID,\t  \tMonetaryFee.previousCPFee AS PREVIOUS_CP_FEE,   \tMonetaryFee.previousOtherFees AS PREVIOUS_OTHER_FEES,  \tPERSON.TIN AS PRIMARY_SOCIAL,  \tSHARE_JOINT.TIN AS JOINT_SOCIAL,  \tPERSON.BIRTH_DATE AS PRIMARY_BIRTH_DATE,      SHARE_JOINT.BIRTH_DATE AS JOINT_BIRTH_DATE,      CASE SHARE.REG_D_PAY      WHEN 'N' THEN 'No'  \tWHEN 'Y' THEN 'Yes'  \tEND AS REG_D_PAY  FROM  \tCORE.ENV AS ENV CROSS JOIN  \tCORE.ACCOUNT AS ACCOUNT INNER JOIN  \tCORE.SHARE AS SHARE ON  \t\tACCOUNT.SERIAL = SHARE.PARENT_SERIAL INNER JOIN  \tCORE.SH_TYPE AS SH_TYPE ON  \t\tSHARE.TYPE_SERIAL = SH_TYPE.SERIAL INNER JOIN  \tCORE.PERSON AS PERSON ON  \t\tACCOUNT.PRIMARY_PERSON_SERIAL = PERSON.SERIAL INNER JOIN  \tAverageBalance ON  \t\tAverageBalance.storedAccessKey = SHARE.STORED_ACCESS_KEY LEFT OUTER JOIN      CORE.SH_PERSON_LINK AS SH_PERSON_LINK ON      \tSHARE.SERIAL = SH_PERSON_LINK.PARENT_SERIAL LEFT OUTER JOIN      CORE.PERSON AS SHARE_JOINT ON      \tSHARE_JOINT.SERIAL = SH_PERSON_LINK.PERSON_SERIAL LEFT OUTER JOIN      CurrentAddress ON      \tCurrentAddress.personSerial = PERSON.SERIAL LEFT OUTER JOIN      CurrentEmail ON          PERSON.SERIAL = CurrentEmail.personSerial LEFT OUTER JOIN      CurrentPhone ON          PERSON.SERIAL = CurrentPhone.personSerial LEFT OUTER JOIN      LastActivityDate ON          ACCOUNT.SERIAL = LastActivityDate.accountSerial LEFT OUTER JOIN      CTEMonetary on      \tSHARE.STORED_ACCESS_KEY = CTEMonetary.targetAccessKey LEFT OUTER JOIN      DividendRate ON      \tSHARE.SERIAL = DividendRate.serial LEFT OUTER JOIN      MonetaryFee on      \tSHARE.STORED_ACCESS_KEY = MonetaryFee.targetAccessKey  WHERE  \tSH_TYPE.CATEGORY IN ('D','S')  ORDER BY   \tACCOUNT_NUMBER ";
        PreparedStatement stmt = connection.prepareStatement(sql);
        ResultSet rset = stmt.executeQuery();
        while (rset.next()) {
            os.println(CSVWriter.formatToCSVData(rset));
        }
        stmt.close();
    }
}

