/*
 * Decompiled with CFR 0.152.
 */
package misc.script.helping;

import com.corelationinc.script.Report;
import com.corelationinc.script.Script;
import com.corelationinc.script.ScriptException;
import com.corelationinc.script.Serial;
import com.corelationinc.script.XMLSerialize;
import com.corelationinc.script.utils.CSV.CSVResultReader;
import com.corelationinc.script.utils.CSV.CSVResultSet;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;

public class PopulateCloseDateExternalAccounts {
    Script script = null;
    PrintStream os = null;

    public static void runScript(Script script) throws Exception {
        PopulateCloseDateExternalAccounts test = new PopulateCloseDateExternalAccounts(script);
        test.run();
    }

    private PopulateCloseDateExternalAccounts(Script value) {
        this.script = value;
    }

    private void run() throws Exception {
        String filePath = this.script.getDatabaseHomePathName() + "/import/";
        String csvFileIn = "/import/loan-import.csv";
        String fileName = "";
        Iterator iterator = this.script.getArgumentIterator();
        if (!iterator.hasNext()) {
            throw new ScriptException("No filename was passed as an argument");
        }
        fileName = (String)iterator.next();
        if (fileName.trim().isEmpty()) {
            throw new ScriptException("No filename was passed as an argument");
        }
        filePath = filePath + fileName;
        Connection connection = this.script.openDatabaseConnection();
        String postingDate = this.script.retrievePostingDateString(connection);
        Report report = this.script.openReport("Populate Close Date based on External Account Number", Report.Format.xml);
        report.setPostingOption(true);
        Report exceptionReport = this.script.openReport("Populate Close Date based on External Account Number", Report.Format.txt);
        exceptionReport.setPostingOption(true);
        this.os = new PrintStream(exceptionReport.getBufferedOutputStream());
        XMLSerialize xml = new XMLSerialize();
        xml.setXMLWriter((OutputStream)report.getBufferedOutputStream());
        xml.putStartDocument();
        xml.putBatchQuery(postingDate);
        CSVResultSet csvRset = CSVResultReader.readCsvData(filePath);
        xml.putSequence();
        int count = 0;
        int lineCount = 0;
        while (csvRset.next()) {
            ++lineCount;
            boolean accountExists = true;
            int pos = -1;
            String importExternalAccountNumber = null;
            Object loanID = null;
            Object noteExplanation = null;
            Date importCloseDate = null;
            boolean validData = true;
            int lineNumber = 0;
            importExternalAccountNumber = csvRset.getString(++pos);
            importCloseDate = csvRset.getDate(++pos);
            System.out.println(importExternalAccountNumber);
            Serial loanSerial = this.getLoanSerial(importExternalAccountNumber, connection);
            if (loanSerial == null || loanSerial.isNull() || lineNumber != 0) {
                if (lineNumber > 0) {
                    this.os.println("Line " + (lineCount + 1) + " and item " + importExternalAccountNumber + " had invalid format and was not processed.");
                    continue;
                }
                this.os.println("Line " + (lineCount + 1) + " and item " + importExternalAccountNumber + "  was not processed because the loan record could not be found.");
                continue;
            }
            String loanTypeCode = this.getLoanCode(importExternalAccountNumber, connection);
            if (count == 1000) {
                xml.put();
                xml.putSequence();
                count = 0;
            }
            xml.putTransaction();
            xml.put("exceptionDescriptionPrefix", "Loan Description: " + importExternalAccountNumber + " new close date: " + importCloseDate + "");
            xml.putStep();
            xml.putRecord();
            xml.putOption("operation", "U");
            xml.put("tableName", "LOAN");
            xml.put("targetSerial", loanSerial);
            xml.put("field");
            xml.put("columnName", "CLOSE_DATE");
            xml.putOption("operation", "S");
            xml.put("newContents", importCloseDate.toString());
            xml.put();
            xml.put();
            xml.put();
            xml.put();
            ++count;
        }
        xml.put();
        xml.put();
        xml.putEndDocument();
    }

    private Serial getLoanSerial(String importExternalAccountNumber, Connection connection) throws SQLException, ScriptException, Exception {
        Report innerExportReport = this.script.openReport("Populate Close Date based on External Account Number Details", Report.Format.txt);
        PrintStream osInner = new PrintStream(innerExportReport.getBufferedOutputStream());
        Serial loanSerial = null;
        String sql = "  SELECT  \tLOAN.SERIAL AS LOAN_SERIAL,  \tLOAN.PARENT_SERIAL AS ACCOUNT_SERIAL,  \tLOAN.EXTERNAL_ACCOUNT_NUMBER AS EXTERNAL_ACCOUNT_NUMBER,  \tLOAN.CLOSE_DATE AS CURRENT_CLOSE_DATE  FROM  \tCORE.ENV AS ENV CROSS JOIN  \tCORE.LOAN AS LOAN INNER JOIN  \tCORE.LN_TYPE AS LN_TYPE ON LN_TYPE.SERIAL=LOAN.TYPE_SERIAL LEFT OUTER JOIN  \tCORE.ACCOUNT AS ACCOUNT ON ACCOUNT.SERIAL=LOAN.PARENT_SERIAL  WHERE  \tLOAN.EXTERNAL_ACCOUNT_NUMBER = '" + importExternalAccountNumber + "'  \tAND (ENV.POSTING_DATE <= '2022-11-30' OR ENV.INSTITUTION_ID IN (96))  \tAND ENV.KS_LAUNCHER_WEBAPP_NAME <> 'Live'  ";
        try (PreparedStatement pstmt = connection.prepareStatement(sql);){
            ResultSet loanRset = pstmt.executeQuery();
            while (loanRset.next()) {
                loanSerial = Serial.get((ResultSet)loanRset, (int)1);
            }
        }
        return loanSerial;
    }

    private String getLoanCode(String importExternalAccountNumber, Connection connection) throws SQLException, ScriptException {
        String loanTypeCode = null;
        String sql = "  SELECT \tLN_TYPE.CODE  FROM \tCORE.LN_TYPE AS LN_TYPE  WHERE \tUCASE(LN_TYPE.DESCRIPTION) LIKE UCASE('%" + importExternalAccountNumber + "%') ";
        try (PreparedStatement pstmt = connection.prepareStatement(sql);){
            ResultSet loanRset = pstmt.executeQuery();
            if (loanRset.next()) {
                loanTypeCode = loanRset.getString(1);
            }
        }
        return loanTypeCode;
    }
}

