/*
 * Decompiled with CFR 0.152.
 */
package misc.script.helping;

import BatchScriptBase.Database.GenericPersonTaskManager;
import BatchScriptBase.TaskManagerBase;
import com.corelationinc.script.Script;
import com.corelationinc.script.ScriptException;
import com.corelationinc.script.Serial;
import com.corelationinc.script.utils.Data.Account;
import com.corelationinc.script.utils.Data.Person;
import com.corelationinc.script.utils.Data.Share;
import com.corelationinc.utils.ScriptAccountUtils;
import com.corelationinc.utils.ScriptPersonUtils;
import com.corelationinc.utils.ScriptUtils;
import com.corelationinc.utils.output.XML.KeyBridge.FeeAssess;
import com.corelationinc.utils.output.XML.KeyBridge.KeyBridgeStep;
import com.corelationinc.utils.output.XML.KeyBridge.Sequence;
import com.corelationinc.utils.output.XML.KeyBridgeOutput;
import java.sql.Date;
import java.util.Arrays;
import java.util.List;

public class PaperStatementFee
extends GenericPersonTaskManager {
    Serial feeSerial;
    Serial feePostingPolicy;
    Serial shTypeBasCheck;
    Serial noteTypePaperStmt;
    Date postingDate;

    public static void runScript(Script script) throws Exception {
        PaperStatementFee manager = new PaperStatementFee(script);
        manager.run();
    }

    public PaperStatementFee(Script value) throws Exception {
        super(value);
    }

    protected PaperStatementFeeTask getTask() throws ScriptException {
        return new PaperStatementFeeTask(this);
    }

    protected void beforeTaskHook() throws Exception {
        this.postingDate = this.getPostingDate();
        this.feeSerial = ScriptUtils.getSerialFromDescription(this.getConnection(), "FEE", "Paper Statement Fee");
        this.feePostingPolicy = ScriptUtils.getPostingPolicySerialFromFee(this.getConnection(), "Paper Statement Fee");
        this.shTypeBasCheck = ScriptUtils.getSerialFromDescription(this.getConnection(), "SH_TYPE", "Basic Checking");
        this.noteTypePaperStmt = ScriptUtils.getSerialFromDescription(this.getConnection(), "NOTE_TYPE", "Paper Stmt Fee Exempt");
    }

    private class PaperStatementFeeTask
    extends GenericPersonTaskManager.GenericPersonTask {
        public PaperStatementFeeTask(PaperStatementFee manager) {
            super((GenericPersonTaskManager)PaperStatementFee.this, (TaskManagerBase)manager);
        }

        public void performTask() throws Exception {
            Sequence seq = new Sequence();
            Person person = this.getPerson();
            if (!person.getCategory().getCode().equals("I") || ScriptPersonUtils.getAgeInYears(this.getConnection(), person.getSerial()) >= 18) {
                for (Account account : person.getAccountList()) {
                    Share feeShare;
                    if (account.getEStatementOption().getCode().equals("E") || ScriptAccountUtils.hasActiveNote(this.getDatabaseConnection(), account.getSerial(), PaperStatementFee.this.postingDate, Arrays.asList(PaperStatementFee.this.noteTypePaperStmt)) || (feeShare = this.getShareToFee(account.getShare())) == null) continue;
                    FeeAssess feeAssess = new FeeAssess();
                    feeAssess.setFeeSerial(PaperStatementFee.this.feeSerial);
                    feeAssess.setPostingPolicySerial(PaperStatementFee.this.feePostingPolicy);
                    feeAssess.setTargetSerial(feeShare.getSerial());
                    seq.addStep((KeyBridgeStep)feeAssess, account.getAccountNumber() + " S " + feeShare.getShareID());
                }
            }
            if (!seq.isEmpty()) {
                this.addKeyBridgeOutput("Paper Statement Fee Posting Report", (KeyBridgeOutput)seq);
            }
        }

        private Share getShareToFee(List<Share> shareList) throws Exception {
            Share feeShare = null;
            for (Share share : shareList) {
                if (!share.getType().equals(PaperStatementFee.this.shTypeBasCheck) || share.getCloseDate() != null) continue;
                if (feeShare == null) {
                    feeShare = share;
                    continue;
                }
                if (!feeShare.getBalance().isLessThan(share.getBalance())) continue;
                feeShare = share;
            }
            return feeShare;
        }
    }
}

