/*
 * Decompiled with CFR 0.152.
 */
package misc.script.helping;

import com.corelationinc.script.Report;
import com.corelationinc.script.Script;
import com.corelationinc.script.utils.CSV.CSVWriter;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class MikeRVelocityExportShareBalances {
    Script script = null;

    public static void runScript(Script script) throws Exception {
        MikeRVelocityExportShareBalances test = new MikeRVelocityExportShareBalances(script);
        test.run();
    }

    private MikeRVelocityExportShareBalances(Script value) {
        this.script = value;
    }

    private void run() throws Exception {
        Connection connection = this.script.openDatabaseConnection();
        Report exportReport = this.script.openReport("Velocity Export Share Balances SendToVendor", Report.Format.txt);
        PrintStream os = new PrintStream(exportReport.getBufferedOutputStream());
        os.println("ACCOUNT_NUMBER,ID,SHARE_TYPE,PRIMARY_NAME,JOINT_NAME,SHARE_JOINT_CATEGORY,STREET,CITY,STATE,POSTAL_CODE,PHONE,EMAIL,PRIMARY_BIRTH_DATE,JOINT_BIRTH_DATE,PRIMARY_SOCIAL,JOINT_SOCIAL,CURRENT_BALANCE,AVERAGE_BALANCE,STATMONTH");
        String sql = "  WITH CurrentAddress(personSerial, street, additionalAddressLine, city, state, postalCode, combinedAddress) AS (      SELECT          PERSON_SERIAL,          COALESCE(ADDRESS.STREET, '') AS STREET,          COALESCE(ADDRESS.ADDITIONAL_ADDRESS_LINE, '') AS ADDITIONAL_ADDRESS_LINE,          COALESCE(ADDRESS.CITY, '') AS CITY,          COALESCE(ADDRESS.STATE, '') AS STATE,          COALESCE(ADDRESS.POSTAL_CODE, '') AS POSTAL_CODE,          COALESCE(ADDRESS.STREET || ' ', '') || COALESCE(ADDRESS.ADDITIONAL_ADDRESS_LINE || ', ', '') ||          COALESCE(ADDRESS.CITY || ' ', '') || COALESCE(ADDRESS.STATE, '') || COALESCE(', ' || ADDRESS.POSTAL_CODE, '') AS COMBINED_ADDRESS      FROM      (          SELECT              PAL.PARENT_SERIAL AS PERSON_SERIAL,              PAL.ADDRESS_SERIAL AS ADDRESS_SERIAL,              COALESCE(PAL.ORDINAL, 0) AS PAL_ORDINAL,              MIN(COALESCE(PAL.ORDINAL, 0)) OVER (PARTITION BY PAL.PARENT_SERIAL) AS MIN_PAL_ORDINAL          FROM              CORE.PERSON_ADDRESS_LINK AS PAL LEFT OUTER JOIN              CORE.ENV AS ENV ON                  ENV.SERIAL > 0          WHERE              (PAL.EFFECTIVE_DATE IS NULL OR              PAL.EFFECTIVE_DATE <= ENV.POSTING_DATE) AND              (PAL.EXPIRATION_DATE IS NULL OR              PAL.EXPIRATION_DATE >= ENV.POSTING_DATE) AND              PAL.BAD_ADDRESS <> 'Y' AND              PAL.CATEGORY <> 'V'      ) LEFT OUTER JOIN          CORE.ADDRESS AS ADDRESS ON              ADDRESS_SERIAL = ADDRESS.SERIAL AND ADDRESS.ADDRESS_FORMAT = 'D'      WHERE          PAL_ORDINAL = MIN_PAL_ORDINAL  ),  CurrentEmail(personSerial, email) AS (      SELECT          PERSON_CONTACT.PARENT_SERIAL AS PERSON_SERIAL,          PERSON_CONTACT.VALUE      FROM          CORE.PERSON_CONTACT AS PERSON_CONTACT       WHERE          PERSON_CONTACT.CATEGORY IN ('PE','BE') AND          PERSON_CONTACT.BAD_CONTACT = 'N' AND          NOT EXISTS (SELECT 1                       FROM                          CORE.PERSON_CONTACT AS PERSON_CONTACT_INNER                      WHERE                          PERSON_CONTACT_INNER.PARENT_SERIAL = PERSON_CONTACT.PARENT_SERIAL AND                          PERSON_CONTACT_INNER.ORDINAL > PERSON_CONTACT.ORDINAL AND                          PERSON_CONTACT.CATEGORY IN ('PE','BE') AND                          PERSON_CONTACT.BAD_CONTACT = 'N')   ),  CurrentPhone(personSerial, phone) AS (      SELECT          PERSON_CONTACT.PARENT_SERIAL AS PERSON_SERIAL,          PERSON_CONTACT.VALUE      FROM          CORE.PERSON_CONTACT AS PERSON_CONTACT       WHERE          PERSON_CONTACT.CATEGORY IN ('HP','BP') AND          PERSON_CONTACT.BAD_CONTACT = 'N' AND          NOT EXISTS (SELECT 1                       FROM                          CORE.PERSON_CONTACT AS PERSON_CONTACT_INNER                      WHERE                          PERSON_CONTACT_INNER.PARENT_SERIAL = PERSON_CONTACT.PARENT_SERIAL AND                          PERSON_CONTACT_INNER.ORDINAL > PERSON_CONTACT.ORDINAL AND                          PERSON_CONTACT.CATEGORY IN ('HP','BP') AND                          PERSON_CONTACT.BAD_CONTACT = 'N')   ),  DefaultDates (postingDate, instName, StartDate, EndDate, statMonth) AS (  \tSELECT  \t  POSTINGDATE,  \t  INSTNAME,  \t  STARTDATE,  \t  ENDDATE,  \t  (TO_CHAR(ENDDATE, 'YYYY-MM')) AS STATISTIC_MONTH  \tFROM  \t\t(  \t\tSELECT  \t\t  ENV.POSTING_DATE AS PostingDate,  \t\t  ENV.INSTITUTION_NAME AS InstName,  \t\t  (ENV.POSTING_DATE - DAY(ENV.POSTING_DATE) DAYS + 1 DAYS - 1 MONTH)  AS STARTDATE,  \t\t  (ENV.POSTING_DATE - DAY(ENV.POSTING_DATE) DAYS) AS ENDDATE  \t\tFROM  \t\t    CORE.ENV AS ENV  \t\t)    ),    DefaultDatesOrig (StartDate, EndDate) AS (      SELECT          DATE('2021-10-01') AS START_DATE,                 DATE('2021-10-31') AS END_DATE      FROM      CORE.ENV AS ENV  ),    SelectedShares (Serial, OpenDate, CloseDate, TmpStartDate, TmpEndDate) AS (      SELECT          SHARE.SERIAL AS SHARE_SERIAL,          SHARE.OPEN_DATE AS OPEN_DATE ,          SHARE.CLOSE_DATE AS CLOSE_DATE,          GREATEST(SHARE.OPEN_DATE, DefaultDates.StartDate) AS TMP_STARTDATE,          LEAST(COALESCE(SHARE.CLOSE_DATE - 1 Day, SHARE.CHARGE_OFF_DATE - 1 Day, DefaultDates.EndDate), DefaultDates.EndDate) AS TMP_ENDDATE      FROM          CORE.SHARE AS SHARE,          DefaultDates      WHERE          SHARE.OPEN_DATE <= DefaultDates.EndDate AND          COALESCE(SHARE.CLOSE_DATE, DefaultDates.StartDate + 1 Day) > DefaultDates.StartDate AND          COALESCE(SHARE.CHARGE_OFF_DATE, DefaultDates.StartDate + 1 Day) > DefaultDates.StartDate  ),   AverageBalance(storedAccessKey, averageBalance) AS (      SELECT          STORED_ACCESS_KEY,          CASE              WHEN DAYS_IN_PERIOD = 0 THEN 0              ELSE CAST(FLOAT(BAL_DAYS) / DAYS_IN_PERIOD + 0.005 AS DECIMAL(16,2))          END AS AVG_BAL      FROM (          SELECT              STORED_ACCESS_KEY,              ACCT,              START_DATE,              END_DATE,              DAYS(END_DATE) - DAYS(START_DATE) + 1 AS DAYS_IN_PERIOD,              SUM(BAL_DAYS) AS BAL_DAYS          FROM (              SELECT                  SHARE.STORED_ACCESS_KEY AS STORED_ACCESS_KEY,                  ACCOUNT.ACCOUNT_NUMBER || ' S ' || SHARE.ID AS ACCT,                  SelectedShares.TmpStartDate AS START_DATE,                  SelectedShares.TmpEndDate AS END_DATE,                  0.00 AS BAL_CHANGE,                  SHARE.BALANCE * (DAYS(SelectedShares.TmpEndDate) - DAYS(SelectedShares.TmpStartDate) + 1) AS BAL_DAYS              FROM                  CORE.SHARE AS SHARE INNER JOIN                  SelectedShares ON                      SHARE.SERIAL = SelectedShares.Serial INNER JOIN                  CORE.ACCOUNT AS ACCOUNT ON                      SHARE.PARENT_SERIAL = ACCOUNT.SERIAL            UNION ALL                SELECT                  SHARE.STORED_ACCESS_KEY AS STORED_ACCESS_KEY,                  ACCOUNT.ACCOUNT_NUMBER || ' S ' || SHARE.ID AS ACCT,                  SelectedShares.TmpStartDate AS START_DATE,                  SelectedShares.TmpEndDate AS END_DATE,                  MONETARY.PRINCIPAL AS BAL_CHANGE,                  -MONETARY.PRINCIPAL * LEAST(DAYS(MONETARY.EFFECTIVE_DATE) - DAYS(SelectedShares.TmpStartDate),                  DAYS(SelectedShares.TmpEndDate) - DAYS(SelectedShares.TmpStartDate) + 1) AS BAL_DAYS              FROM                  CORE.SHARE AS SHARE INNER JOIN                  SelectedShares ON                      SHARE.SERIAL = SelectedShares.Serial INNER JOIN                  CORE.ACCOUNT AS ACCOUNT ON                      SHARE.PARENT_SERIAL = ACCOUNT.SERIAL INNER JOIN                  CORE.MONETARY AS MONETARY ON                     MONETARY.TARGET_ACCESS_KEY = SHARE.STORED_ACCESS_KEY AND                      MONETARY.POSTING_DATE > SelectedShares.TmpStartDate              WHERE                  MONETARY.STATUS = 'P' AND                  MONETARY.PRINCIPAL <> 0.00          )      GROUP BY          STORED_ACCESS_KEY,          ACCT,          START_DATE,          END_DATE,          DAYS(END_DATE) - DAYS(START_DATE) + 1      )  )  SELECT          ACCOUNT.ACCOUNT_NUMBER,          SHARE.ID,          SH_TYPE.DESCRIPTION AS SHARE_TYPE,          PERSON.LAST_NAME || COALESCE(',' || PERSON.FIRST_NAME, '') AS PRIMARY_NAME,          SHARE_JOINT.LAST_NAME || COALESCE(',' || SHARE_JOINT.FIRST_NAME, '') AS JOINT_NAME,          CASE SH_PERSON_LINK.CATEGORY          WHEN 'JT' THEN 'Joint owner'          WHEN 'AS' THEN 'Authorized signer'          WHEN 'PA' THEN 'Power of attorney'          WHEN 'TR' THEN 'Trustee'          WHEN 'CU' THEN 'Custodian'          WHEN 'GD' THEN 'Guardian'          WHEN 'CV' THEN 'Conservator'          WHEN 'RP' THEN 'Representative payee'          WHEN 'VF' THEN 'VA fiduciary'          WHEN 'AD' THEN 'Administrator'          WHEN 'EX' THEN 'Executor'          WHEN 'ST' THEN 'Successor trustee'          WHEN 'SC' THEN 'Successor custodian'          WHEN 'SR' THEN 'Settlor'          WHEN 'BE' THEN 'Beneficiary'          WHEN 'BC' THEN 'Contingent beneficiary'          WHEN 'RB' THEN 'Revocable trust beneficiary'          WHEN 'RC' THEN 'Contingent revocable trust beneficiary'          WHEN 'IB' THEN 'Irrevocable trust beneficiary'          WHEN 'IC' THEN 'Contingent irrevocable trust beneficiary'          WHEN 'AU' THEN 'Authorized user'          WHEN 'BO' THEN 'Beneficial owner'          WHEN 'CP' THEN 'Control person'          WHEN 'AA' THEN 'Additional mailing addressee'          WHEN 'OT' THEN 'Other related party'          END AS SHARE_JOINT_CATEGORY,          CurrentAddress.street || COALESCE ((', ') || CurrentAddress.additionalAddressLine, '') AS STREET,      CurrentAddress.city AS CITY,           CurrentAddress.state AS STATE,           CurrentAddress.postalCode AS POSTAL_CODE,          CurrentPhone.phone AS PHONE,          CurrentEmail.email AS EMAIL,      PERSON.BIRTH_DATE AS PRIMARY_BIRTH_DATE,      SHARE_JOINT.BIRTH_DATE AS JOINT_BIRTH_DATE,      PERSON.TIN AS PRIMARY_SOCIAL,          SHARE_JOINT.TIN AS JOINT_SOCIAL,          SHARE.BALANCE AS CURRENT_BALANCE,          AverageBalance.averageBalance AS AVERAGE_BALANCE,      DefaultDates.statMonth  FROM          DefaultDates as DefaultDates CROSS JOIN          CORE.ACCOUNT AS ACCOUNT INNER JOIN          CORE.SHARE AS SHARE ON                 ACCOUNT.SERIAL = SHARE.PARENT_SERIAL INNER JOIN          CORE.SH_TYPE AS SH_TYPE ON                 SHARE.TYPE_SERIAL = SH_TYPE.SERIAL INNER JOIN          CORE.PERSON AS PERSON ON                 ACCOUNT.PRIMARY_PERSON_SERIAL = PERSON.SERIAL INNER JOIN          AverageBalance ON          AverageBalance.storedAccessKey = SHARE.STORED_ACCESS_KEY LEFT OUTER JOIN      CORE.SH_PERSON_LINK AS SH_PERSON_LINK ON          SHARE.SERIAL = SH_PERSON_LINK.PARENT_SERIAL LEFT OUTER JOIN      CORE.PERSON AS SHARE_JOINT ON          SHARE_JOINT.SERIAL = SH_PERSON_LINK.PERSON_SERIAL LEFT OUTER JOIN      CurrentAddress ON          CurrentAddress.personSerial = PERSON.SERIAL LEFT OUTER JOIN      CurrentEmail ON          PERSON.SERIAL = CurrentEmail.personSerial LEFT OUTER JOIN      CurrentPhone ON          PERSON.SERIAL = CurrentPhone.personSerial  WHERE          ACCOUNT.CLOSE_DATE IS NULL AND          SHARE.CLOSE_DATE IS NULL AND          SHARE.CHARGE_OFF_DATE IS NULL AND           PERSON.DEATH_DATE IS NULL AND          SH_TYPE.SERIAL IN ('39','58','62')   ORDER BY           ACCOUNT_NUMBER ";
        PreparedStatement stmt = connection.prepareStatement(sql);
        ResultSet rset = stmt.executeQuery();
        while (rset.next()) {
            os.println(CSVWriter.formatToCSVData(rset));
        }
        stmt.close();
    }
}

