/*
 * Decompiled with CFR 0.152.
 */
package misc.script.helping;

import com.corelationinc.script.Script;
import com.corelationinc.script.ScriptException;
import com.corelationinc.script.Serial;
import com.corelationinc.script.XMLSerialize;
import com.corelationinc.utils.MultiThreadScript;
import com.corelationinc.utils.ScriptLoanUtils;
import com.corelationinc.utils.ScriptUtils;

public class HELOCAnnualFee
extends MultiThreadScript {
    Serial typeSerial;
    Serial feeSerial;
    Serial postingPolicySerial;

    public void beforeTasks() throws Exception {
        this.typeSerial = ScriptUtils.getSerialFromDescription(this.getConnection(), "LN_TYPE", "Home Equity LOC");
        this.feeSerial = ScriptUtils.getSerialFromDescription(this.getConnection(), "FEE", "HELOC Annual Fee");
        this.postingPolicySerial = ScriptUtils.getPostingPolicySerialFromFee(this.getConnection(), "HELOC Annual Fee");
    }

    public static void runScript(Script script) {
        HELOCAnnualFee manager = new HELOCAnnualFee(script);
        manager.run();
    }

    public HELOCAnnualFee(Script value) {
        super(value);
    }

    @Override
    protected String getNextTaskSQL() throws ScriptException {
        return "SELECT\tLOAN.SERIAL,     LOAN.ID FROM\tCORE.LOAN AS LOAN INNER JOIN\tCORE.LN_TYPE AS LN_TYPE ON\t\tLOAN.TYPE_SERIAL=LN_TYPE.SERIAL CROSS JOIN\tCORE.ENV AS ENV WHERE\t(LOAN.OPEN_DATE + 6 MONTHS) <= ENV.POSTING_DATE AND\tLOAN.BALANCE > 0.00 AND\tLOAN.CREDIT_LIMIT <> 0.00 AND\tLN_TYPE.DESCRIPTION = 'Home Equity LOC'";
    }

    @Override
    protected MultiThreadScript.MultiThreadTask getTask() throws ScriptException {
        return new MultiThreadTaskTemplate((MultiThreadScript)this);
    }

    private class MultiThreadTaskTemplate
    extends MultiThreadScript.MultiThreadTask {
        Serial loanSerial;
        String accNum;
        String loanID;

        public MultiThreadTaskTemplate(MultiThreadScript manager) {
            super(manager);
        }

        public void perform() throws Exception {
            this.loanSerial = this.getSerial();
            this.loanID = this.getString();
            this.accNum = ScriptLoanUtils.getAccountNumber(this.getConnection(), this.loanSerial) + " L " + this.loanID;
            this.enableOutput();
        }

        public void output() throws Exception {
            XMLSerialize xml = HELOCAnnualFee.this.getXMLReport("Heloc Annual Fee");
            xml.putSequence();
            xml.putTransaction();
            xml.put("exceptionDescriptionPrefix", this.accNum);
            xml.putStep();
            xml.put("feeAssess");
            xml.put("feeSerial", HELOCAnnualFee.this.feeSerial.toKeyBridgeString());
            xml.putOption("targetCategory", "L");
            xml.put("targetSerial", this.loanSerial.toKeyBridgeString());
            if (HELOCAnnualFee.this.postingPolicySerial != null) {
                xml.putForce("postingPolicySerial", HELOCAnnualFee.this.postingPolicySerial.toKeyBridgeString());
            }
            xml.put();
            xml.put();
            xml.put();
            xml.put();
        }
    }
}

