/*
 * Decompiled with CFR 0.152.
 */
package inst.id123;

import com.corelationinc.script.Report;
import com.corelationinc.script.Script;
import com.corelationinc.script.Serial;
import com.corelationinc.script.XMLSerialize;
import com.corelationinc.script.utils.CSV.CSVWriter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class VISACardLoanDescriptionUpdate {
    Script script = null;

    public static void runScript(Script script) throws Exception {
        VISACardLoanDescriptionUpdate batch = new VISACardLoanDescriptionUpdate(script);
        batch.run();
    }

    private VISACardLoanDescriptionUpdate(Script value) {
        this.script = value;
    }

    private void run() throws Exception {
        Connection connection = this.script.openDatabaseConnection();
        String postingDate = this.script.retrievePostingDateString(connection);
        Report report = this.script.openReport("VISA Card Loan Description Update", Report.Format.xml);
        report.setPostingOption(true);
        PrintStream os = new PrintStream(report.getBufferedOutputStream());
        Report innerExportReport = this.script.openReport("VISA_SQL_LINE_ITEMS_" + postingDate, Report.Format.txt);
        PrintStream osInner = new PrintStream(innerExportReport.getBufferedOutputStream());
        String varname1 = " SELECT DISTINCT  \tACCOUNT.ACCOUNT_NUMBER || ' L ' || LOAN.ID AS ACCOUNT_NUMBER,  \tACCOUNT.SERIAL AS ACCOUNT_SERIAL,  \tLOAN.SERIAL AS LOAN_SERIAL,  \tLOAN.DESCRIPTION AS ORIGINAL_DESCRIPTION,  \tCASE WHEN LOAN.DESCRIPTION IS NULL THEN LOAN.DESCRIPTION ELSE COALESCE(LOAN.DESCRIPTION,'VISA CREDIT CARD') || ' ' || RIGHT(CARD.CARD_NUMBER, 4) END AS NEW_DESCRIPTION,  \tCARD.CARD_NUMBER AS CARD_NUMBER,  \tCARD_TYPE.DESCRIPTION AS CARD_TYPE_DESCRIPTION  FROM  \tCORE.ENV AS ENV INNER JOIN  \tCORE.LOAN AS LOAN ON LOAN.CLOSE_DATE IS NULL INNER JOIN   \tCORE.LN_TYPE AS LN_TYPE ON LOAN.TYPE_SERIAL=LN_TYPE.SERIAL INNER JOIN  \tCORE.ACCOUNT AS ACCOUNT ON LOAN.PARENT_SERIAL=ACCOUNT.SERIAL AND ACCOUNT.CLOSE_DATE IS NULL INNER JOIN  \tCORE.CARD_ACCESS AS CARD_ACCESS ON LOAN.SERIAL=CARD_ACCESS.LOAN_SERIAL INNER JOIN  \tCORE.CARD AS CARD ON CARD_ACCESS.PARENT_SERIAL=CARD.SERIAL INNER JOIN  \tCORE.CARD_TYPE AS CARD_TYPE ON CARD.TYPE_SERIAL=CARD_TYPE.SERIAL  WHERE  \tLOAN.CHARGE_OFF_DATE IS NULL AND   \tLOAN.CLOSE_DATE IS NULL AND  \tACCOUNT.CLOSE_DATE IS NULL  \tAND CARD.STATUS IN ('I')  \tAND (UCASE(CARD_TYPE.DESCRIPTION) LIKE '%CONSUMER%' OR UCASE(CARD_TYPE.DESCRIPTION) LIKE '%VISA CC%')   \tAND CARD_TYPE.CATEGORY IN ('V','D')   \tAND RIGHT(LOAN.DESCRIPTION,4)<>RIGHT(CARD.CARD_NUMBER, 4)   \tAND (ENV.POSTING_DATE <= '2022-01-01' OR ENV.INSTITUTION_ID IN (96,123))  ORDER BY  \tACCOUNT.ACCOUNT_NUMBER || ' L ' || LOAN.ID  ";
        PreparedStatement stmt = connection.prepareStatement(varname1);
        ResultSet rset = stmt.executeQuery();
        XMLSerialize xml = new XMLSerialize();
        xml.setXMLWriter((OutputStream)os);
        xml.putStartDocument();
        xml.putBatchQuery(postingDate);
        while (rset.next()) {
            int pos = 0;
            String accountNumber = rset.getString(++pos);
            Serial accountSerial = Serial.get((ResultSet)rset, (int)(++pos));
            Serial loanSerial = Serial.get((ResultSet)rset, (int)(++pos));
            String originalDescription = rset.getString(++pos);
            String newDescription = rset.getString(++pos);
            String cardNumber = rset.getString(++pos);
            String cardTypeDescription = rset.getString(++pos);
            osInner.println(CSVWriter.formatToCSVData(rset));
            xml.put("sequence");
            xml.put("transaction");
            xml.put("exceptionDescriptionPrefix", accountNumber + " with a loan description of: " + originalDescription + "");
            xml.put("step");
            xml.put("record");
            xml.putOption("operation", "U");
            xml.put("tableName", "LOAN");
            xml.put("targetSerial", loanSerial);
            xml.put("field");
            xml.put("columnName", "DESCRIPTION");
            xml.putOption("operation", "S");
            xml.put("newContents", newDescription);
            xml.put();
            xml.put();
            xml.put();
            xml.put();
            xml.put();
        }
        xml.put();
        xml.putEndDocument();
    }
}

