/*
 * Decompiled with CFR 0.152.
 */
package com.corelationinc.utils.XML;

import com.corelationinc.script.Money;
import com.corelationinc.script.Serial;
import com.corelationinc.script.XMLSerialize;
import javax.xml.stream.XMLStreamException;

public class PostingRequest {
    private final CATEGORY category;
    private final Serial targetSerial;
    private final String exceptionDescriptionPrefix;
    private Serial recipientSerial;
    private Money amount;
    private Serial GLSerial;
    private TARGET_CATEGORY targetCategory;
    private RECIPIENT_CATEGORY recipientCategory;
    private TRANSFER_OPTION transferOption;
    private String description;

    private PostingRequest(String exceptionDescriptionPrefix, CATEGORY category, Serial targetSerial) {
        this.exceptionDescriptionPrefix = exceptionDescriptionPrefix;
        this.category = category;
        this.targetSerial = targetSerial;
    }

    protected void setAmount(Money amount) {
        this.amount = amount;
    }

    protected void setGLSerial(Serial GLSerial) {
        this.GLSerial = GLSerial;
    }

    protected void setTargetCategory(TARGET_CATEGORY targetCategory) {
        this.targetCategory = targetCategory;
    }

    protected void setRecipientCategory(RECIPIENT_CATEGORY recipientCategory) {
        this.recipientCategory = recipientCategory;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    protected void setTransferOption(TRANSFER_OPTION transferOption) {
        this.transferOption = transferOption;
    }

    protected void setRecipientSerial(Serial recipientSerial) {
        this.recipientSerial = recipientSerial;
    }

    public final void putStep(XMLSerialize xml) throws XMLStreamException {
        xml.putStep();
        xml.put("postingRequest");
        xml.putOption("category", this.category.databaseTranslation);
        xml.put("targetSerial", this.targetSerial.toKeyBridgeString());
        if (this.transferOption != null) {
            xml.putOption("transferOption", this.transferOption.databaseTranslation);
        }
        if (this.targetCategory != null) {
            xml.putOption("targetCategory", this.targetCategory.databaseTranslation);
        }
        if (this.recipientCategory != null) {
            xml.putOption("recipientCategory", this.recipientCategory.databaseTranslation);
        }
        if (this.amount != null) {
            xml.put("amount", this.amount);
        }
        if (this.GLSerial != null) {
            xml.put("glAccountSerial", this.GLSerial);
        }
        if (this.recipientSerial != null) {
            xml.put("recipientSerial", this.recipientSerial);
        }
        if (this.description != null) {
            xml.put("description", this.description);
        }
        xml.put();
        xml.put();
    }

    public final void putTransaction(XMLSerialize xml) throws XMLStreamException {
        xml.putTransaction();
        xml.put("exceptionDescriptionPrefix", this.exceptionDescriptionPrefix);
        this.putStep(xml);
        xml.put();
    }

    public final void putSequence(XMLSerialize xml) throws XMLStreamException {
        xml.putSequence();
        this.putTransaction(xml);
        xml.put();
    }

    public static class TransferRequest
    extends PostingRequest {
        public TransferRequest(String exceptionDescriptionPrefix, CATEGORY category, TARGET_CATEGORY targetCategory, Serial targetSerial, TRANSFER_OPTION transferOption, RECIPIENT_CATEGORY recipientCategory, Serial recipientSerial, Money amount) {
            super(exceptionDescriptionPrefix, CATEGORY.WITHDRAWAL, targetSerial);
            this.setTransferOption(TRANSFER_OPTION.TRANSFER);
            this.setTargetCategory(targetCategory);
            this.setRecipientCategory(recipientCategory);
            this.setRecipientSerial(recipientSerial);
            this.setAmount(amount);
        }
    }

    public static class CommentRequest
    extends PostingRequest {
        public CommentRequest(String exceptionDescriptionPrefix, TARGET_CATEGORY targetCategory, Serial targetSerial, String description) {
            super(exceptionDescriptionPrefix, CATEGORY.COMMENT, targetSerial);
            this.setTargetCategory(targetCategory);
            this.setDescription(description);
        }
    }

    public static class GLOffsetRequest
    extends PostingRequest {
        public GLOffsetRequest(String exceptionDescriptionPrefix, CATEGORY category, Serial targetSerial, TARGET_CATEGORY targetCategory, Serial GLSerial, Money amount) {
            super(exceptionDescriptionPrefix, category, targetSerial);
            this.setTargetCategory(targetCategory);
            this.setGLSerial(GLSerial);
            this.setAmount(amount);
        }

        public GLOffsetRequest(String exceptionDescriptionPrefix, CATEGORY category, Serial targetSerial, TARGET_CATEGORY targetCategory, Serial GLSerial, Money amount, String description) {
            super(exceptionDescriptionPrefix, category, targetSerial);
            this.setTargetCategory(targetCategory);
            this.setGLSerial(GLSerial);
            this.setAmount(amount);
            this.setDescription(description);
        }
    }

    public static enum TRANSFER_OPTION {
        TRANSFER("T", "Transfer"),
        NONE("-", "None");

        String databaseTranslation;
        String englishTranslation;

        private TRANSFER_OPTION(String databaseTranslation, String englishTranslation) {
            this.databaseTranslation = databaseTranslation;
            this.englishTranslation = englishTranslation;
        }
    }

    public static enum RECIPIENT_CATEGORY {
        SHARE("S", "Share"),
        LOAN("L", "Loan"),
        CHECKING_ACCOUNT("K", "Checking account");

        String databaseTranslation;
        String englishTranslation;

        private RECIPIENT_CATEGORY(String databaseTranslation, String englishTranslation) {
            this.databaseTranslation = databaseTranslation;
            this.englishTranslation = englishTranslation;
        }
    }

    public static enum TARGET_CATEGORY {
        SHARE("S", "Share"),
        LOAN("L", "Loan"),
        CHECKING_ACCOUNT("K", "Checking account");

        String databaseTranslation;
        String englishTranslation;

        private TARGET_CATEGORY(String databaseTranslation, String englishTranslation) {
            this.databaseTranslation = databaseTranslation;
            this.englishTranslation = englishTranslation;
        }
    }

    public static enum CATEGORY {
        NONE("-", "None"),
        DEPOSIT_OR_PAYMENT("D", "Deposit or payment"),
        WITHDRAWAL("W", "Withdrawal or advance"),
        REFINANCE("R", "Refinance"),
        NEW_LOAN("N", "New loan"),
        FEE("F", "Fee"),
        COMMENT("C", "Comment"),
        HOLD_PLACEMENT("H", "Hold placement"),
        HOLD_RELEASE("h", "Hold release"),
        GENERAL_LEDGER("G", "General ledger"),
        CHECK_RECONCILIATION("K", "Check reconciliation");

        String databaseTranslation;
        String englishTranslation;

        private CATEGORY(String databaseTranslation, String englishTranslation) {
            this.databaseTranslation = databaseTranslation;
            this.englishTranslation = englishTranslation;
        }
    }
}

