/*
 * Decompiled with CFR 0.152.
 */
package com.corelationinc.utils.XML;

import com.corelationinc.script.Money;
import com.corelationinc.script.ScriptException;
import com.corelationinc.script.Serial;
import com.corelationinc.script.XMLSerialize;
import java.sql.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class Fee {
    private final Map<String, String> map = new HashMap<String, String>();

    public Fee(Serial feeSerial, Serial targetSerial, TARGET_CATEGORY targetCategory, String exceptionDescription) throws ScriptException {
        if (feeSerial == null) {
            throw new ScriptException("Null fee serial passed to Fee constructor.");
        }
        this.map.put("feeSerial", feeSerial.toKeyBridgeString());
        if (targetSerial == null) {
            throw new ScriptException("Null target serial passed to Fee constructor.");
        }
        this.map.put("targetSerial", targetSerial.toKeyBridgeString());
        if (targetCategory == TARGET_CATEGORY.SHARE) {
            this.map.put("targetCategory", "S");
        } else {
            this.map.put("targetCategory", "L");
        }
        this.map.put("exceptionDescriptionPrefix", exceptionDescription);
    }

    public void putTransaction(XMLSerialize xml) throws XMLStreamException {
        xml.putTransaction();
        xml.put("exceptionDescriptionPrefix", this.map.get("exceptionDescriptionPrefix"));
        this.putStep(xml);
        xml.put();
    }

    public void putStep(XMLSerialize xml) throws XMLStreamException {
        xml.putStep();
        xml.put("feeAssess");
        xml.put("feeSerial", this.map.get("feeSerial"));
        xml.putOption("targetCategory", this.map.get("targetCategory"));
        xml.put("targetSerial", this.map.get("targetSerial"));
        xml.put("postingPolicySerial", this.map.get("postingPolicySerial"));
        if (this.map.get("effectiveDate") != null) {
            xml.put("effectiveDate", this.map.get("effectiveDate"));
        }
        if (this.map.get("adjustmentOption") != null) {
            xml.putOption("adjustmentOption", this.map.get("adjustmentOption"));
        }
        if (this.map.get("specifiedFeeOption") != null) {
            xml.putOption("specifiedFeeOption", this.map.get("specifiedFeeOption"));
        }
        if (this.map.get("specifiedFeeAmount") != null) {
            xml.put("specifiedFeeAmount", this.map.get("specifiedFeeAmount"));
        }
        xml.put();
        xml.put();
    }

    public void putSequence(XMLSerialize xml) throws XMLStreamException {
        xml.putSequence();
        this.putTransaction(xml);
        xml.put();
    }

    public void setPostingPolicy(Serial postingPolicySerial) throws ScriptException {
        if (postingPolicySerial == null) {
            throw new ScriptException("Null posting policy serial passed to setPostingPolicySerial.");
        }
        this.map.put("postingPolicySerial", postingPolicySerial.toKeyBridgeString());
    }

    public void setEffectiveDate(Date effectiveDate) throws ScriptException {
        if (effectiveDate == null) {
            throw new ScriptException("Null effectiveDate passed to setEffectiveDate.");
        }
        this.map.put("effectiveDate", effectiveDate.toString());
    }

    public void setAdjustmentOption(ADJUSTMENT_OPTION adjustmentOption) {
        if (adjustmentOption == ADJUSTMENT_OPTION.NO) {
            this.map.put("adjustmentOption", "-");
        } else {
            this.map.put("adjustmentOption", "A");
        }
    }

    public void setRelationshipSerial(Serial relationshipSerial) throws ScriptException {
        if (relationshipSerial == null) {
            throw new ScriptException("Null relationship serial passed to setRelationshipSerial.");
        }
        this.map.put("relationshipSerial", relationshipSerial.toKeyBridgeString());
    }

    public void setSpecifiedFeeOption(SPECIFIED_FEE_OPTION specifiedFeeOption) {
        switch (specifiedFeeOption) {
            case NO: {
                this.map.put("specifiedFeeOption", "N");
                return;
            }
            case YES: {
                this.map.put("specifiedFeeOption", "Y");
                return;
            }
            case COUNT: {
                this.map.put("specifiedFeeOption", "C");
                return;
            }
            case WAIVE_COUNTING: {
                this.map.put("specifiedFeeOption", "W");
                return;
            }
        }
    }

    public void setSpecifiedFeeAmount(Money specifiedFeeAmount) throws ScriptException {
        if (specifiedFeeAmount == null) {
            throw new ScriptException("Null specified fee amount passed to setSpecifiedFeeAmount.");
        }
        this.map.put("specifiedFeeAmount", specifiedFeeAmount.toKeyBridgeString());
    }

    public static enum SPECIFIED_FEE_OPTION {
        NO,
        YES,
        COUNT,
        WAIVE_COUNTING;

    }

    public static enum ADJUSTMENT_OPTION {
        NO,
        ADJUSTMENT;

    }

    public static enum TARGET_CATEGORY {
        SHARE,
        LOAN;

    }
}

