/*
 * Decompiled with CFR 0.152.
 */
package com.corelationinc.utils.XML;

import com.corelationinc.script.ScriptException;
import com.corelationinc.script.Serial;
import com.corelationinc.script.XMLSerialize;
import com.corelationinc.utils.ScriptUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class FM {

    public static class FMDeleteAll
    extends FMOperation {
        public FMDeleteAll(String tableName, Serial targetSerial, String exceptionDescriptionPrefix) {
            this.tableName = tableName;
            this.targetSerial = targetSerial == null ? "" : targetSerial.toKeyBridgeString();
            this.exceptionDescriptionPrefix = exceptionDescriptionPrefix;
        }

        @Override
        public void putStep(XMLSerialize xml) throws XMLStreamException {
            xml.putStep();
            xml.put("recordDelete");
            xml.put("tableName", this.tableName);
            xml.put("targetSerial", this.targetSerial);
            xml.put();
            xml.put();
        }
    }

    public static class FMDelete
    extends FMOperation {
        public FMDelete(String tableName, Serial targetSerial, String exceptionDescriptionPrefix) {
            this.tableName = tableName;
            this.targetSerial = targetSerial == null ? "" : targetSerial.toKeyBridgeString();
            this.exceptionDescriptionPrefix = exceptionDescriptionPrefix;
        }

        @Override
        public void putStep(XMLSerialize xml) throws XMLStreamException {
            xml.putStep();
            xml.putRecord();
            xml.putOption("operation", "D");
            xml.put("tableName", this.tableName);
            xml.put("targetSerial", this.targetSerial);
            xml.put();
            xml.put();
        }
    }

    public static class FMUpdate
    extends FMOperation {
        FieldUpdate[] updateFields = new FieldUpdate[0];

        public FMUpdate(String tableName, Serial targetSerial, String exceptionDescriptionPrefix, FieldUpdate ... updateFields) {
            this.tableName = tableName;
            this.targetSerial = targetSerial == null ? "" : targetSerial.toKeyBridgeString();
            this.exceptionDescriptionPrefix = exceptionDescriptionPrefix;
            this.updateFields = updateFields;
        }

        public FMUpdate(String tableName, Serial targetSerial, String exceptionDescriptionPrefix, List<FieldUpdate> updateFields) {
            this.tableName = tableName;
            this.targetSerial = targetSerial == null ? "" : targetSerial.toKeyBridgeString();
            this.exceptionDescriptionPrefix = exceptionDescriptionPrefix;
            this.updateFields = updateFields.toArray(new FieldUpdate[updateFields.size()]);
        }

        @Override
        public void putStep(XMLSerialize xml) throws XMLStreamException {
            xml.putStep();
            xml.putRecord();
            xml.putOption("operation", "U");
            xml.put("tableName", this.tableName);
            xml.put("targetSerial", this.targetSerial);
            for (FieldUpdate field : this.updateFields) {
                xml.put("field");
                xml.put("columnName", field.getColumnName());
                if (field.getPutForceNewContents()) {
                    xml.putForce("newContents", field.getNewContents());
                } else {
                    xml.put("newContents", field.getNewContents());
                }
                if (field.getPutForceOldContents()) {
                    xml.putForce("oldContents", field.getOldContents());
                } else {
                    xml.put("oldContents", field.getOldContents());
                }
                xml.put();
            }
            xml.put();
            xml.put();
        }
    }

    public static class FMInsertOnParent
    extends FMOperation {
        private FieldInsert[] newFields = new FieldInsert[0];

        public FMInsertOnParent(String tableName, Serial targetParentSerial, String exceptionDescriptionPrefix, FieldInsert ... newFields) {
            this.tableName = tableName;
            this.targetParentSerial = targetParentSerial == null ? "" : targetParentSerial.toKeyBridgeString();
            this.exceptionDescriptionPrefix = exceptionDescriptionPrefix;
            this.newFields = newFields;
        }

        public FMInsertOnParent(String tableName, Serial targetParentSerial, String exceptionDescriptionPrefix, List<FieldInsert> newFields) {
            this.tableName = tableName;
            this.targetParentSerial = targetParentSerial == null ? "" : targetParentSerial.toKeyBridgeString();
            this.exceptionDescriptionPrefix = exceptionDescriptionPrefix;
            this.newFields = newFields.toArray(new FieldInsert[newFields.size()]);
        }

        @Override
        public void putStep(XMLSerialize xml) throws XMLStreamException {
            xml.putStep();
            xml.putRecord();
            xml.putOption("operation", "I");
            xml.put("tableName", this.tableName);
            xml.put("targetParentSerial", this.targetParentSerial);
            for (FieldInsert field : this.newFields) {
                xml.put("field");
                xml.put("columnName", field.getColumnName());
                if (field.getPutForceNewContents()) {
                    xml.putForce("newContents", field.getNewContents());
                } else {
                    xml.put("newContents", field.getNewContents());
                }
                xml.put();
            }
            xml.put();
            xml.put();
        }
    }

    public static class FMInsert
    extends FMOperation {
        private List<FieldInsert> newFields = new ArrayList<FieldInsert>();

        public FMInsert(String tableName, String exceptionDescriptionPrefix, FieldInsert ... newFields) {
            this.tableName = tableName;
            this.exceptionDescriptionPrefix = exceptionDescriptionPrefix;
            this.newFields.addAll(Arrays.asList(newFields));
        }

        public FMInsert(String tableName, String exceptionDescriptionPrefix, List<FieldInsert> newFields) {
            this.tableName = tableName;
            this.exceptionDescriptionPrefix = exceptionDescriptionPrefix;
            this.newFields = newFields;
        }

        public void addFieldInsert(FieldInsert field) throws ScriptException {
            if (field == null) {
                throw new ScriptException("Cannot pass a null field");
            }
            this.newFields.add(field);
        }

        @Override
        public void putStep(XMLSerialize xml) throws XMLStreamException {
            xml.putStep();
            xml.putRecord();
            xml.putOption("operation", "I");
            xml.put("tableName", this.tableName);
            for (FieldInsert field : this.newFields) {
                xml.put("field");
                xml.put("columnName", field.getColumnName());
                if (field.getPutForceNewContents()) {
                    xml.putForce("newContents", field.getNewContents());
                } else {
                    xml.put("newContents", field.getNewContents());
                }
                xml.put();
            }
            xml.put();
            xml.put();
        }
    }

    public static abstract class FMOperation {
        protected String tableName = null;
        protected String targetSerial = null;
        protected String targetParentSerial = null;
        protected String exceptionDescriptionPrefix = null;

        public abstract void putStep(XMLSerialize var1) throws XMLStreamException;

        public final void putTransaction(XMLSerialize xml) throws XMLStreamException {
            xml.putTransaction();
            xml.put("exceptionDescriptionPrefix", this.exceptionDescriptionPrefix);
            this.putStep(xml);
            xml.put();
        }

        public final void putSequence(XMLSerialize xml) throws XMLStreamException {
            xml.putSequence();
            this.putTransaction(xml);
            xml.put();
        }
    }

    public static class FieldUpdate {
        private final Field field;
        private boolean putForceNewContents = false;
        private boolean putForceOldContents = false;

        public FieldUpdate(String columnName, String oldContents, String newContents) throws ScriptException {
            this.field = new Field(columnName, oldContents, newContents);
        }

        public FieldUpdate(String columnName, Serial oldContents, Serial newContents) throws ScriptException {
            this.field = new Field(columnName, oldContents.toString(), newContents.toString());
        }

        public String getColumnName() {
            return this.field.getColumnName();
        }

        public String getOldContents() {
            return this.field.getOldContents();
        }

        public String getNewContents() {
            return this.field.getNewContents();
        }

        private boolean getPutForceNewContents() {
            return this.putForceNewContents;
        }

        private boolean getPutForceOldContents() {
            return this.putForceOldContents;
        }

        public void enablePutForceNewContents() {
            this.putForceNewContents = true;
        }

        public void enablePutForceOldContents() {
            this.putForceOldContents = true;
        }
    }

    public static class FieldInsert {
        private final Field field;
        private boolean putForceNewContents = false;

        public FieldInsert(String columnName, String newContents) throws ScriptException {
            this.field = new Field(columnName, "", newContents);
        }

        public String getColumnName() {
            return this.field.getColumnName();
        }

        public String getNewContents() {
            return this.field.getNewContents();
        }

        public boolean getPutForceNewContents() {
            return this.putForceNewContents;
        }

        public void enablePutForceNewContents() {
            this.putForceNewContents = true;
        }
    }

    private static class Field {
        private String columnName = null;
        private String oldContents = null;
        private String newContents = null;

        private Field(String columnName, String oldContents, String newContents) throws ScriptException {
            this.columnName = (String)ScriptUtils.coalesce(columnName, "");
            this.oldContents = (String)ScriptUtils.coalesce(oldContents, "");
            this.newContents = (String)ScriptUtils.coalesce(newContents, "");
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getOldContents() {
            return this.oldContents;
        }

        public String getNewContents() {
            return this.newContents;
        }
    }
}

