/*
 * Decompiled with CFR 0.152.
 */
package com.corelationinc.utils;

import com.corelationinc.script.ScriptException;
import com.corelationinc.script.Serial;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ScriptUtils {
    public static String createInStatementVariables(int variableCount) {
        if (variableCount <= 0) {
            return "";
        }
        String questionMarks = "";
        for (int i = 0; i < variableCount; ++i) {
            questionMarks = questionMarks + "?,";
        }
        return questionMarks.substring(0, questionMarks.length() - 1);
    }

    public static String createInStatementVariables(Collection collection) {
        int i = ScriptUtils.createInstatementVariablesInternal(collection, 0);
        return ScriptUtils.createInStatementVariables(i);
    }

    public static String createInStatementVariables(Object[] array) {
        int i = ScriptUtils.createInstatementVariablesInternal(array, 0);
        return ScriptUtils.createInStatementVariables(i);
    }

    private static int createInstatementVariablesInternal(Object object, int currCounter) {
        if (object instanceof Collection) {
            Collection coll = (Collection)object;
            for (Object obj : coll) {
                currCounter = ScriptUtils.createInstatementVariablesInternal(obj, currCounter);
            }
            return currCounter;
        }
        if (object instanceof Object[]) {
            Object[] coll;
            for (Object obj : coll = (Object[])object) {
                currCounter = ScriptUtils.createInstatementVariablesInternal(obj, currCounter);
            }
            return currCounter;
        }
        return ++currCounter;
    }

    public static String getDescriptionFromSerial(Connection connection, String tableName, Serial serial) throws SQLException, ScriptException {
        String sql = "SELECT      DESCRIPTION  FROM     CORE." + tableName.toUpperCase() + " WHERE      SERIAL =  ? ";
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            serial.set(stmt, 1);
            ResultSet rset = stmt.executeQuery();
            if (rset.next()) {
                String string = rset.getString(1);
                return string;
            }
        }
        throw new ScriptException("Could Not Find Description For Serial: " + serial.toString());
    }

    public static Serial getSerialFromDescription(Connection connection, String tableName, String description) throws SQLException, ScriptException {
        List<Serial> returnedList = ScriptUtils.getSerialFromDescription(connection, tableName, Arrays.asList(description));
        return !returnedList.isEmpty() ? returnedList.get(0) : null;
    }

    public static List<Serial> getSerialFromDescription(Connection connection, String tableName, List<String> descriptions) throws SQLException, ScriptException {
        String sql = "SELECT \tSERIAL  FROM CORE." + tableName.toUpperCase() + " WHERE\tDESCRIPTION = ?";
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            ArrayList<Serial> serialList = new ArrayList<Serial>();
            for (String description : descriptions) {
                stmt.setString(1, description);
                ResultSet rset = stmt.executeQuery();
                Serial serial = null;
                if (rset.next()) {
                    serial = Serial.get((ResultSet)rset, (int)1);
                }
                if (serial == null) {
                    throw new ScriptException("Could Not Find Serial Under Table: " + tableName + " For Description: " + description);
                }
                serialList.add(serial);
            }
            ArrayList<Serial> arrayList = serialList;
            return arrayList;
        }
    }

    public static Object coalesce(Object ... objs) throws ScriptException {
        for (Object o : objs) {
            if (o == null) continue;
            return o;
        }
        throw new ScriptException("All arguments null, no valid coalesce defaults found.");
    }

    public static String coalesceToString(Object ... objs) throws ScriptException {
        for (Object o : objs) {
            if (o == null) continue;
            return o.toString();
        }
        throw new ScriptException("All arguments null, no valid coalesce defaults found.");
    }

    public static Serial getPostingPolicySerialFromFee(Connection conn, String feeDesc) throws Exception {
        String sql = "SELECT  POSTING_POLICY_SERIAL FROM  CORE.FEE WHERE  DESCRIPTION = ?";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, feeDesc);
            ResultSet rset = stmt.executeQuery();
            if (rset.next()) {
                Serial serial = Serial.get((ResultSet)rset, (int)1);
                return serial;
            }
        }
        throw new ScriptException("No fee record exists with a description of: " + feeDesc);
    }

    public static enum LOAN_TYPE_CATEGORY {
        CLOSED_END,
        OPEN_END,
        LINE_OF_CREDIT,
        CREDIT_CARD;

    }
}

