/*
 * Decompiled with CFR 0.152.
 */
package com.corelationinc.utils;

import com.corelationinc.script.ScriptException;
import com.corelationinc.script.Serial;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ScriptShareUtils {
    public static boolean isDormant(Connection connection, Serial shareSerial, int daysWithoutActivity) throws SQLException, ScriptException {
        if (connection == null) {
            throw new ScriptException("Null connection passed to isDormant.");
        }
        if (shareSerial == null) {
            throw new ScriptException("Null shareSerial passed to isDormant.");
        }
        String sql = "SELECT    1 FROM\t CORE.SHARE AS SHARE INNER JOIN\t CORE.ENV AS ENV ON\t        ENV.SERIAL > 0 WHERE    ENV.POSTING_DATE - ? DAYS > SHARE.LAST_ACTIVITY_DATE AND    SHARE.SERIAL = ?";
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setInt(1, daysWithoutActivity);
            shareSerial.set(stmt, 2);
            ResultSet rset = stmt.executeQuery();
            boolean bl = rset.next();
            return bl;
        }
    }

    public static boolean isNegative(Connection connection, Serial shareSerial) throws SQLException, ScriptException {
        if (connection == null) {
            throw new ScriptException("Null connection passed to isNegative.");
        }
        if (shareSerial == null) {
            throw new ScriptException("Null shareSerial passed to isNegative.");
        }
        String sql = " SELECT    1 FROM    CORE.SHARE AS SHARE  WHERE    SHARE.SERIAL = ? AND    SHARE.BALANCE < 0";
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            shareSerial.set(stmt, 1);
            ResultSet rset = stmt.executeQuery();
            boolean bl = rset.next();
            return bl;
        }
    }

    public static int daysSinceLastNegativeMonetary(Connection connection, Serial shareSerial) throws SQLException, ScriptException {
        if (connection == null) {
            throw new ScriptException("Null connection passed to daysSinceLastNegativeMonetary.");
        }
        if (shareSerial == null) {
            throw new ScriptException("Null shareSerial passed to daysSinceLastNegativeMonetary.");
        }
        String sql = "WITH LastNegativeMonetary(targetAccessKey,postingDate) AS (    SELECT        MONETARY.TARGET_ACCESS_KEY,        MAX(MONETARY.POSTING_DATE)    FROM        CORE.MONETARY AS MONETARY     WHERE        MONETARY.STATUS='P' AND        MONETARY.NEW_BALANCE < 0.00 AND        MONETARY.NEW_BALANCE - MONETARY.PRINCIPAL >= 0.00    GROUP BY        MONETARY.TARGET_ACCESS_KEY    ) SELECT    CASE WHEN LastNegativeMonetary.targetAccessKey IS NULL THEN 0    ELSE DAYS(ENV.POSTING_DATE) - DAYS(LastNegativeMonetary.postingDate) END AS DAYS_SINCE_LAST_NEG FROM    CORE.SHARE AS SHARE LEFT OUTER JOIN    LastNegativeMonetary ON        SHARE.STORED_ACCESS_KEY = LastNegativeMonetary.targetAccessKey LEFT OUTER JOIN    CORE.ENV AS ENV ON        ENV.SERIAL > 0 WHERE    SHARE.SERIAL = ?";
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            shareSerial.set(stmt, 1);
            ResultSet rset = stmt.executeQuery();
            if (rset.next()) {
                int n = rset.getInt(1);
                return n;
            }
            int n = 0;
            return n;
        }
    }

    public static boolean isNegativeXDays(Connection connection, Serial shareSerial, int daysNegative) throws SQLException, ScriptException {
        if (connection == null) {
            throw new ScriptException("Null connection passed to isNegativeXDays.");
        }
        if (shareSerial == null) {
            throw new ScriptException("Null shareSerial passed to isNegativeXDays.");
        }
        if (daysNegative < 0) {
            throw new ScriptException("Invalid number of days passed to isNegativeXDays.");
        }
        boolean isNegative = ScriptShareUtils.isNegative(connection, shareSerial);
        boolean hasBeenNegativeXDays = ScriptShareUtils.daysSinceLastNegativeMonetary(connection, shareSerial) >= daysNegative;
        return isNegative && hasBeenNegativeXDays;
    }
}

