/*
 * Decompiled with CFR 0.152.
 */
package com.corelationinc.utils;

import com.corelationinc.script.ScriptException;
import com.corelationinc.script.Serial;
import com.corelationinc.utils.ScriptUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class ScriptPersonUtils {
    public static boolean hasActiveNotes(Connection conn, Serial personSerial, Date postingDate, List<Serial> noteTypeList) throws Exception {
        if (conn == null) {
            throw new ScriptException("Cannot pass a null connection is null");
        }
        if (personSerial == null || personSerial.isNull()) {
            throw new ScriptException("Cannot pass a null or empty person serial");
        }
        if (postingDate == null) {
            throw new ScriptException("Cannot pass a null posting date");
        }
        if (noteTypeList == null || noteTypeList.isEmpty()) {
            throw new ScriptException("Cannot pass a null or empty note type list");
        }
        String sql = "SELECT  1 FROM  CORE.PE_NOTE WHERE  PARENT_SERIAL = ? AND  (EXPIRATION_DATE = NULL OR   EXPIRATION_DATE >= ?) AND  TYPE_SERIAL IN (" + ScriptUtils.createInStatementVariables(noteTypeList.size()) + ")";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            int index = 0;
            personSerial.set(stmt, ++index);
            stmt.setDate(++index, postingDate);
            for (Serial serial : noteTypeList) {
                serial.set(stmt, ++index);
            }
            ResultSet rset = stmt.executeQuery();
            boolean bl = rset.next();
            return bl;
        }
    }

    public static int getAgeInYears(Connection connection, Serial personSerial) throws SQLException {
        String sql = "SELECT     YEAR(ENV.POSTING_DATE - PERSON.BIRTH_DATE) FROM     CORE.PERSON AS PERSON CROSS JOIN     CORE.ENV AS ENV WHERE     PERSON.SERIAL = ?";
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            personSerial.set(stmt, 1);
            ResultSet rset = stmt.executeQuery();
            if (rset.next()) {
                int n = rset.getInt(1);
                return n;
            }
            int n = 0;
            return n;
        }
    }
}

