/*
 * Decompiled with CFR 0.152.
 */
package com.corelationinc.utils;

import com.corelationinc.script.Money;
import com.corelationinc.script.Rate;
import com.corelationinc.script.ScriptException;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class ScriptMathUtils {
    public static String CLASS_NAME = "ScriptMathUtils";

    private static void verifyArguments(Variable ... varList) throws ScriptException {
        if (varList.length > 0) {
            for (Variable var : varList) {
                var.verifyContents();
            }
        }
    }

    public static Money divide(Money dividend, Rate divisor) throws Exception {
        return new Money(ScriptMathUtils.divide(new BigDecimal(dividend.toKeyBridgeString()), new BigDecimal(divisor.toKeyBridgeString()), 2, RoundingMode.HALF_UP).toString());
    }

    public static Money divide(Money dividend, Money divisor) throws Exception {
        BigDecimal divid = new BigDecimal(dividend.toKeyBridgeString());
        BigDecimal div = new BigDecimal(divisor.toKeyBridgeString());
        System.out.println(div.toPlainString());
        System.out.println(divid.toPlainString());
        System.out.println(divid.divide(div, 2, RoundingMode.HALF_UP));
        return new Money(ScriptMathUtils.divide(new BigDecimal(dividend.toKeyBridgeString()), new BigDecimal(divisor.toKeyBridgeString()), 2, RoundingMode.HALF_UP).toString());
    }

    public static BigDecimal divide(BigDecimal dividend, BigDecimal divisor, int scale, RoundingMode roundMode) throws Exception {
        String methodHandler = CLASS_NAME + ".divide";
        ScriptMathUtils.verifyArguments(new Variable(dividend, "dividend", methodHandler), new Variable(divisor, "divisor", methodHandler));
        if (divisor.compareTo(BigDecimal.ZERO) == 0) {
            throw new ScriptException("Variable Name: divisor cannot be 0 in method: " + CLASS_NAME + ".divide");
        }
        return dividend.divide(divisor, scale, roundMode);
    }

    public static Money multiply(Money multiplicand, Rate multiplier) throws Exception {
        return new Money(ScriptMathUtils.multiply(new BigDecimal(multiplicand.toKeyBridgeString()), new BigDecimal(multiplier.toKeyBridgeString()), 2, RoundingMode.HALF_UP).toString());
    }

    public static Money multiply(Money multiplicand, Money multiplier) throws Exception {
        return new Money(ScriptMathUtils.multiply(new BigDecimal(multiplicand.toString()), new BigDecimal(multiplier.toString()), 2, RoundingMode.HALF_UP).toString());
    }

    public static BigDecimal multiply(BigDecimal multiplicand, BigDecimal multiplier, int scale, RoundingMode roundMode) throws Exception {
        String methodHandler = CLASS_NAME + ".multiply";
        ScriptMathUtils.verifyArguments(new Variable(multiplicand, "multiplicand", methodHandler), new Variable(multiplier, "multiplier", methodHandler));
        return multiplicand.multiply(multiplier).setScale(scale, roundMode);
    }

    private static class Variable {
        private final Object var;
        private final String varName;
        private final String methodHandler;

        public Variable(Object var, String varName, String methodHandler) throws ScriptException {
            if (varName == null || varName.isEmpty()) {
                throw new ScriptException("Cannot pass a null or empty variable name");
            }
            if (methodHandler == null || methodHandler.isEmpty()) {
                throw new ScriptException("Cannot pass a null or empty variable name");
            }
            this.var = var;
            this.varName = varName;
            this.methodHandler = methodHandler;
        }

        public void verifyContents() throws ScriptException {
            if (this.var == null) {
                throw new ScriptException("Variable Name: " + this.varName + " cannot be null in method: " + this.methodHandler);
            }
        }
    }
}

