/*
 * Decompiled with CFR 0.152.
 */
package com.corelationinc.utils;

import com.corelationinc.script.ScriptException;
import com.corelationinc.script.Serial;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ScriptLoanUtils {
    public static String getAccountNumber(Connection connection, Serial loanSerial) throws SQLException, ScriptException {
        if (connection == null) {
            throw new ScriptException("Null connection passed to getAccountNumber.");
        }
        if (loanSerial == null) {
            throw new ScriptException("Null loan serial passed to getAccountNumber.");
        }
        String sql = "SELECT\tACCOUNT.ACCOUNT_NUMBER FROM\tCORE.LOAN AS LOAN INNER JOIN     CORE.ACCOUNT AS ACCOUNT ON         LOAN.PARENT_SERIAL = ACCOUNT.SERIAL WHERE    LOAN.SERIAL = ?";
        Throwable throwable = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            loanSerial.set(stmt, 1);
            ResultSet rset = stmt.executeQuery();
            if (rset.next()) {
                String string = rset.getString(1);
                return string;
            }
            try {
                throw new ScriptException("No loan found with given serial: " + loanSerial.toString());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

