/*
 * Decompiled with CFR 0.152.
 */
package com.corelationinc.utils;

import com.corelationinc.script.ScriptException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class ScriptDateUtils {
    public static java.sql.Date getToday(Connection connection) throws SQLException, ScriptException {
        if (connection == null) {
            throw new ScriptException("Attempted to fetch current posting date from null connection.");
        }
        if (connection.isClosed()) {
            throw new ScriptException("Attempted to fetch current posting date from closed connection.");
        }
        String sql = "SELECT     ENV.POSTING_DATE FROM     CORE.ENV AS ENV";
        Throwable throwable = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            ResultSet rset = stmt.executeQuery();
            if (rset.next()) {
                java.sql.Date date = rset.getDate(1);
                return date;
            }
            try {
                throw new ScriptException("Unable to fetch current posting date from database.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static java.sql.Date getYesterday(Connection connection) throws SQLException, ScriptException {
        if (connection == null) {
            throw new ScriptException("Attempted to fetch current posting date from null connection.");
        }
        if (connection.isClosed()) {
            throw new ScriptException("Attempted to fetch current posting date from closed connection.");
        }
        String sql = "SELECT     ENV.POSTING_DATE - 1 DAY FROM     CORE.ENV AS ENV";
        Throwable throwable = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            ResultSet rset = stmt.executeQuery();
            if (rset.next()) {
                java.sql.Date date = rset.getDate(1);
                return date;
            }
            try {
                throw new ScriptException("Unable to fetch current posting date from database.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static java.sql.Date getTomorrow(Connection connection) throws SQLException, ScriptException {
        java.sql.Date today = ScriptDateUtils.getToday(connection);
        return ScriptDateUtils.addXDays(today, 1);
    }

    public static java.sql.Date getDate(Date utilDate) {
        if (utilDate == null) {
            return null;
        }
        long epochSeconds = utilDate.getTime();
        java.sql.Date sqlDate = new java.sql.Date(epochSeconds);
        return sqlDate;
    }

    public static java.sql.Date getPreviousDate(Connection connection, int days) throws SQLException, ScriptException {
        if (connection == null) {
            throw new ScriptException("Attempted to fetch previous posting date from null connection.");
        }
        if (connection.isClosed()) {
            throw new ScriptException("Attempted to fetch previous posting date from closed connection.");
        }
        String sql = "SELECT     ENV.POSTING_DATE - " + String.valueOf(days) + " DAYS FROM     CORE.ENV AS ENV";
        Throwable throwable = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            ResultSet rset = stmt.executeQuery();
            if (rset.next()) {
                java.sql.Date date = rset.getDate(1);
                return date;
            }
            try {
                throw new ScriptException("Unable to fetch previous date from database.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static java.sql.Date subtractXYears(java.sql.Date date, int years) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, -years);
        java.sql.Date previousDate = new java.sql.Date(cal.getTimeInMillis());
        return previousDate;
    }

    public static java.sql.Date addXYears(java.sql.Date date, int years) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, years);
        java.sql.Date previousDate = new java.sql.Date(cal.getTimeInMillis());
        return previousDate;
    }

    public static java.sql.Date addXMonths(java.sql.Date date, int months) throws ScriptException {
        if (date == null) {
            return null;
        }
        if (months < 0) {
            throw new ScriptException("Negative month count passed to addXMonths.");
        }
        return ScriptDateUtils.manipulateCalendarXMonths(date, months);
    }

    public static java.sql.Date subtractXMonths(java.sql.Date date, int months) throws ScriptException {
        if (date == null) {
            return null;
        }
        if (months < 0) {
            throw new ScriptException("Negative month count passed to subtractXMonths.");
        }
        return ScriptDateUtils.manipulateCalendarXMonths(date, -months);
    }

    private static java.sql.Date manipulateCalendarXMonths(java.sql.Date date, int months) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, months);
        java.sql.Date newDate = new java.sql.Date(cal.getTimeInMillis());
        return newDate;
    }

    public static java.sql.Date subtractXDays(java.sql.Date date, int days) {
        return ScriptDateUtils.manipulateCalendarXDays(date, -days);
    }

    public static java.sql.Date addXDays(java.sql.Date date, int days) {
        return ScriptDateUtils.manipulateCalendarXDays(date, days);
    }

    private static java.sql.Date manipulateCalendarXDays(java.sql.Date date, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        java.sql.Date newDate = new java.sql.Date(cal.getTimeInMillis());
        return days == 0 ? date : newDate;
    }

    public static java.sql.Date getEarliestDate(List<java.sql.Date> dates) {
        if (dates == null || dates.isEmpty()) {
            return null;
        }
        java.sql.Date earliest = dates.get(0);
        for (java.sql.Date date : dates) {
            if (!date.before(earliest)) continue;
            earliest = date;
        }
        return earliest;
    }

    public static java.sql.Date getLatestDate(List<java.sql.Date> dates) {
        if (dates == null || dates.isEmpty()) {
            return null;
        }
        java.sql.Date latest = dates.get(0);
        for (java.sql.Date date : dates) {
            if (!date.after(latest)) continue;
            latest = date;
        }
        return latest;
    }

    public static boolean dateBetween(java.sql.Date startDate, java.sql.Date endDate, java.sql.Date targetDate) throws ScriptException {
        if (startDate == null) {
            throw new ScriptException("Cannot evaluate range for null date expression.");
        }
        if (endDate == null) {
            throw new ScriptException("Cannot evaluate range for null date expression.");
        }
        if (targetDate == null) {
            throw new ScriptException("Cannot evaluate range for null date expression.");
        }
        if (startDate.equals(targetDate)) {
            return true;
        }
        if (endDate.equals(targetDate)) {
            return true;
        }
        return targetDate.after(startDate) && targetDate.before(endDate);
    }

    public static int getDaysBetween(java.sql.Date startDate, java.sql.Date endDate) throws ScriptException {
        if (startDate == null) {
            throw new ScriptException("Cannot evaluate range for null date expression.");
        }
        if (endDate == null) {
            throw new ScriptException("Cannot evaluate range for null date expression.");
        }
        if (startDate.equals(endDate)) {
            return 0;
        }
        LocalDate start = startDate.toLocalDate();
        LocalDate end = endDate.toLocalDate();
        int ctr = 1;
        if (start.isBefore(end)) {
            while (start.plusDays(ctr).isBefore(end)) {
                ++ctr;
            }
            return ctr;
        }
        while (start.minusDays(ctr).isBefore(end)) {
            ++ctr;
        }
        return -ctr;
    }

    public static java.sql.Date getDateYYYYMMDD(String dateString) throws ScriptException {
        Date utilDate;
        if (dateString == null || dateString.isEmpty()) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            utilDate = df.parse(dateString);
        }
        catch (ParseException ex) {
            throw new ScriptException("Unable to parse string into date.");
        }
        return new java.sql.Date(utilDate.getTime());
    }

    public static java.sql.Date getMonthStart(Connection connection) throws SQLException, ScriptException {
        if (connection == null) {
            throw new ScriptException("Attempted to fetch current posting date from null connection.");
        }
        if (connection.isClosed()) {
            throw new ScriptException("Attempted to fetch current posting date from closed connection.");
        }
        String sql = " SELECT  \tPOSTING_DATE + 1 DAY - DAY(POSTING_DATE) DAYS FROM \tCORE.ENV";
        Throwable throwable = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            ResultSet rset = stmt.executeQuery();
            if (rset.next()) {
                java.sql.Date date = rset.getDate(1);
                return date;
            }
            try {
                throw new ScriptException("Unable to fetch last day of the current month from database.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static String getTodayLetterDate(Connection connection) throws SQLException, ScriptException {
        if (connection == null) {
            throw new ScriptException("Attempted to fetch current posting date from null connection.");
        }
        if (connection.isClosed()) {
            throw new ScriptException("Attempted to fetch current posting date from closed connection.");
        }
        String sql = " SELECT  \tMONTHNAME(POSTING_DATE) || ' ' || DAY(POSTING_DATE) || ', ' || YEAR(POSTING_DATE) AS GOOD_DATES FROM \tCORE.ENV";
        Throwable throwable = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            ResultSet rset = stmt.executeQuery();
            if (rset.next()) {
                String string = rset.getString(1);
                return string;
            }
            try {
                throw new ScriptException("Unable to fetch curent day from database.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static java.sql.Date getDateFromString(String dateString, String dateFormat) throws ScriptException {
        SimpleDateFormat df = new SimpleDateFormat(dateFormat);
        try {
            Date utilDay = df.parse(dateString);
            java.sql.Date date = new java.sql.Date(utilDay.getTime());
            return date;
        }
        catch (Exception e) {
            throw new ScriptException("Invalid date format.");
        }
    }

    public static java.sql.Date getMonthStartPreviousMonth(Connection connection) throws SQLException, ScriptException {
        if (connection == null) {
            throw new ScriptException("Attempted to fetch current posting date from null connection.");
        }
        if (connection.isClosed()) {
            throw new ScriptException("Attempted to fetch current posting date from closed connection.");
        }
        String sql = " SELECT \tPOSTING_DATE + 1 DAY - DAY(POSTING_DATE) DAYS - DAY(POSTING_DATE + 1 DAY - DAY(POSTING_DATE) DAYS - 1 DAY) DAYS  FROM\tCORE.ENV AS ENV";
        Throwable throwable = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            ResultSet rset = stmt.executeQuery();
            if (rset.next()) {
                java.sql.Date date = rset.getDate(1);
                return date;
            }
            try {
                throw new ScriptException("Unable to fetch ENV from database.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static String getYear(java.sql.Date targetDate) throws Exception {
        return ScriptDateUtils.getValuesFromDate(targetDate, 0, 4);
    }

    public static String getMonth(java.sql.Date targetDate) throws Exception {
        return ScriptDateUtils.getValuesFromDate(targetDate, 5, 7);
    }

    public static String getDays(java.sql.Date targetDate) throws Exception {
        return ScriptDateUtils.getValuesFromDate(targetDate, 8, 10);
    }

    private static String getValuesFromDate(java.sql.Date targetDate, int beginIndex, int endIndex) throws Exception {
        if (targetDate == null) {
            throw new ScriptException("Cannot pass a null target date");
        }
        String date = targetDate.toString();
        if (date.length() != 10) {
            throw new ScriptException("Invalid date size, it must be 10 characters long");
        }
        return date.substring(beginIndex, endIndex);
    }

    public static java.sql.Date getMonthEndPreviousMonth(Connection connection) throws SQLException, ScriptException {
        if (connection == null) {
            throw new ScriptException("Attempted to fetch current posting date from null connection.");
        }
        if (connection.isClosed()) {
            throw new ScriptException("Attempted to fetch current posting date from closed connection.");
        }
        String sql = " SELECT  \tLAST_DAY(POSTING_DATE - 1 MONTH) FROM \tCORE.ENV";
        Throwable throwable = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            ResultSet rset = stmt.executeQuery();
            if (rset.next()) {
                java.sql.Date date = rset.getDate(1);
                return date;
            }
            try {
                throw new ScriptException("Unable to fetch ENV from database.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static DateSet getMonthStartEndDates(CalandarMonth month, String year) throws Exception {
        if (year == null || year.isEmpty()) {
            throw new ScriptException("Cannot pass a null or empty year");
        }
        if (year.length() != 4) {
            throw new ScriptException("The year must be 4 characters long");
        }
        String tempDate = year + "-" + month.getCalandarIndexAsString() + "-";
        java.sql.Date startDate = java.sql.Date.valueOf(tempDate + "01");
        java.sql.Date endDate = month.equals((Object)CalandarMonth.FEBRUARY) && ScriptDateUtils.isLeapYear(year) ? java.sql.Date.valueOf(tempDate + "29") : java.sql.Date.valueOf(tempDate + month.getDaysInCalandarMonthAsString());
        return new DateSet(startDate, endDate);
    }

    public static boolean isLeapYear(java.sql.Date date) throws Exception {
        return ScriptDateUtils.isLeapYear(ScriptDateUtils.getYear(date));
    }

    public static boolean isLeapYear(String year) throws Exception {
        if (year == null || year.isEmpty()) {
            throw new ScriptException("Cannot pass a null or empty year");
        }
        if (year.length() != 4) {
            throw new ScriptException("The year must be 4 characters long");
        }
        Integer leapYear = Integer.valueOf(year);
        if (leapYear % 400 == 0) {
            return true;
        }
        return leapYear % 100 != 0 && leapYear % 4 == 0;
    }

    public static class DateSet {
        private final java.sql.Date startDate;
        private final java.sql.Date endDate;

        public DateSet(java.sql.Date start, java.sql.Date end) {
            this.startDate = start;
            this.endDate = end;
        }

        public java.sql.Date getStartDate() {
            return this.startDate;
        }

        public java.sql.Date getEndDate() {
            return this.endDate;
        }
    }

    public static enum CalandarMonth {
        JANUARY("January", 1, 31),
        FEBRUARY("February", 2, 28),
        MARCH("March", 3, 31),
        APRIL("April", 4, 30),
        MAY("May", 5, 31),
        JUNE("June", 6, 30),
        JULY("July", 7, 31),
        AUGUST("August", 8, 31),
        SEPTEMBER("september", 9, 30),
        OCTOBER("October", 10, 31),
        NOVEMBER("November", 11, 30),
        DECEMBER("December", 12, 31);

        private final String calandarName;
        private final int calandarIndex;
        private final int daysInMonth;
        private final int qtr;

        private CalandarMonth(String name, int index, int daysInMonth) {
            this.calandarName = name;
            this.calandarIndex = index;
            this.daysInMonth = daysInMonth;
            this.qtr = this.calandarIndex < 4 ? 1 : (this.calandarIndex < 7 ? 2 : (this.calandarIndex < 10 ? 3 : 4));
        }

        public String getCalandarName() {
            return this.calandarName;
        }

        public int getCalandarIndex() {
            return this.calandarIndex;
        }

        public String getCalandarIndexAsString() {
            return this.calandarIndex > 9 ? String.valueOf(this.calandarIndex) : "0" + String.valueOf(this.calandarIndex);
        }

        public int getDaysInCalandarMonth() {
            return this.daysInMonth;
        }

        public String getDaysInCalandarMonthAsString() {
            return String.valueOf(this.daysInMonth);
        }

        public int getCalandarMonthQuarter() {
            return this.qtr;
        }

        public static CalandarMonth getMonth(int month) {
            switch (month) {
                case 1: {
                    return JANUARY;
                }
                case 2: {
                    return FEBRUARY;
                }
                case 3: {
                    return MARCH;
                }
                case 4: {
                    return APRIL;
                }
                case 5: {
                    return MAY;
                }
                case 6: {
                    return JUNE;
                }
                case 7: {
                    return JULY;
                }
                case 8: {
                    return AUGUST;
                }
                case 9: {
                    return SEPTEMBER;
                }
                case 10: {
                    return OCTOBER;
                }
                case 11: {
                    return NOVEMBER;
                }
            }
            return DECEMBER;
        }

        public static List<CalandarMonth> getCalandarYear() {
            return Arrays.asList(JANUARY, FEBRUARY, MARCH, APRIL, MAY, JUNE, JULY, AUGUST, SEPTEMBER, OCTOBER, NOVEMBER, DECEMBER);
        }
    }

    public static enum CalandarQuarter {
        FIRST,
        SECOND,
        THIRD,
        FOURTH;

    }
}

