/*
 * Decompiled with CFR 0.152.
 */
package com.corelationinc.utils;

import com.corelationinc.script.ScriptException;
import com.corelationinc.script.Serial;
import com.corelationinc.utils.ScriptUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ScriptAccountUtils {
    public static boolean hasChargeOffs(Connection connection, Serial accountSerial) throws SQLException, ScriptException {
        if (connection == null) {
            throw new ScriptException("Null connection passed to hasChargeOffs.");
        }
        if (accountSerial == null) {
            throw new ScriptException("Null account serial passed to hasChargeOffs.");
        }
        boolean hasChargeOffShares = ScriptAccountUtils.hasChargedOffShares(connection, accountSerial);
        boolean hasChargeOffLoans = ScriptAccountUtils.hasChargedOffLoans(connection, accountSerial);
        return hasChargeOffShares || hasChargeOffLoans;
    }

    public static boolean hasChargedOffShares(Connection connection, Serial accountSerial) throws SQLException, ScriptException {
        if (connection == null) {
            throw new ScriptException("Null connection passed to hasChargedOffShares.");
        }
        if (accountSerial == null) {
            throw new ScriptException("Null account serial passed to hasChargedOffShares.");
        }
        String sql = "SELECT    1 FROM    CORE.SHARE WHERE    CHARGE_OFF_DATE IS NOT NULL AND    PARENT_SERIAL = ?";
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            accountSerial.set(stmt, 1);
            ResultSet rset = stmt.executeQuery();
            boolean bl = rset.next();
            return bl;
        }
    }

    public static boolean hasChargedOffLoans(Connection connection, Serial accountSerial) throws SQLException, ScriptException {
        if (connection == null) {
            throw new ScriptException("Null connection passed to hasChargedOffLoans.");
        }
        if (accountSerial == null) {
            throw new ScriptException("Null account serial passed to hasChargedOffLoans.");
        }
        String sql = "SELECT    1 FROM    CORE.LOAN WHERE    CHARGE_OFF_DATE IS NOT NULL AND    PARENT_SERIAL = ?";
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            accountSerial.set(stmt, 1);
            ResultSet rset = stmt.executeQuery();
            boolean bl = rset.next();
            return bl;
        }
    }

    public static boolean hasDelinquentLoan(Connection connection, Serial accountSerial, int minimumDaysDelinquent) throws SQLException, ScriptException {
        return ScriptAccountUtils.hasDelinquentLoan(connection, accountSerial, minimumDaysDelinquent, ScriptUtils.LOAN_TYPE_CATEGORY.CLOSED_END, ScriptUtils.LOAN_TYPE_CATEGORY.CREDIT_CARD, ScriptUtils.LOAN_TYPE_CATEGORY.LINE_OF_CREDIT, ScriptUtils.LOAN_TYPE_CATEGORY.OPEN_END);
    }

    public static boolean hasDelinquentLoan(Connection connection, Serial accountSerial, int minimumDaysDelinquent, ScriptUtils.LOAN_TYPE_CATEGORY ... categories) throws ScriptException, SQLException {
        if (connection == null) {
            throw new ScriptException("Null connection passed to hasDelinquentLoan.");
        }
        if (accountSerial == null) {
            throw new ScriptException("Null account serial passed to hasDelinquentLoan.");
        }
        if (minimumDaysDelinquent < 0) {
            throw new ScriptException("Negative minimum days delinquent passed to hasDelinquentLoan.");
        }
        if (categories == null) {
            throw new ScriptException("Empty loan category list passed to hasDelinquentLoan.");
        }
        HashSet<String> loanTypeCategories = new HashSet<String>();
        block15: for (ScriptUtils.LOAN_TYPE_CATEGORY category : categories) {
            switch (category) {
                case CLOSED_END: {
                    loanTypeCategories.add("CE");
                    continue block15;
                }
                case OPEN_END: {
                    loanTypeCategories.add("OE");
                    continue block15;
                }
                case LINE_OF_CREDIT: {
                    loanTypeCategories.add("LC");
                    continue block15;
                }
                case CREDIT_CARD: {
                    loanTypeCategories.add("CC");
                }
            }
        }
        String sql = "SELECT    1 FROM    CORE.LOAN AS LOAN INNER JOIN    CORE.LN_TYPE AS LN_TYPE ON        LOAN.TYPE_SERIAL = LN_TYPE.SERIAL LEFT OUTER JOIN    CORE.ENV AS ENV ON        ENV.SERIAL > 0 WHERE    LOAN.PARENT_SERIAL = ? AND    LOAN.PAYMENT_DUE_DATE + ? DAYS < ENV.POSTING_DATE AND    LOAN.BALANCE <> 0 AND    LN_TYPE.CATEGORY IN (" + ScriptUtils.createInStatementVariables(loanTypeCategories) + ") AND    LOAN.CLOSE_DATE IS NULL AND    LOAN.CHARGE_OFF_DATE IS NULL";
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            int i = 1;
            accountSerial.set(stmt, i++);
            stmt.setInt(i++, minimumDaysDelinquent);
            for (String category : loanTypeCategories) {
                stmt.setString(i++, category);
            }
            ResultSet rset = stmt.executeQuery();
            boolean bl = rset.next();
            return bl;
        }
    }

    public static boolean hasActiveNote(Connection connection, Serial accountSerial, String noteDescription) throws SQLException, ScriptException {
        if (connection == null) {
            throw new ScriptException("Null connection passed to hasActiveNote.");
        }
        if (accountSerial == null) {
            throw new ScriptException("Null account serial passed to hasActiveNote.");
        }
        if (noteDescription == null) {
            throw new ScriptException("Null note description passed to hasActiveNote.");
        }
        ArrayList<String> noteDescriptionList = new ArrayList<String>();
        noteDescriptionList.add(noteDescription);
        return ScriptAccountUtils.hasActiveNote(connection, accountSerial, noteDescriptionList);
    }

    public static boolean hasActiveNote(Connection connection, Serial accountSerial, List<String> noteDescriptions) throws SQLException, ScriptException {
        if (connection == null) {
            throw new ScriptException("Null connection passed to getOpenNonChargedOffLoansAccessKeys.");
        }
        if (accountSerial == null) {
            throw new ScriptException("Null account serial passed to getOpenNonChargedOffLoansAccessKeys.");
        }
        if (noteDescriptions == null) {
            throw new ScriptException("Null note descriptions passed to getOpenNonChargedOffLoansAccessKeys.");
        }
        if (noteDescriptions.isEmpty()) {
            throw new ScriptException("Empty note descriptions passed to getOpenNonChargedOffLoansAccessKeys.");
        }
        String sql = "SELECT    1 FROM    CORE.AC_NOTE AS AC_NOTE INNER JOIN    CORE.NOTE_TYPE AS NOTE_TYPE ON        AC_NOTE.TYPE_SERIAL = NOTE_TYPE.SERIAL INNER JOIN    CORE.ENV AS ENV ON        ENV.SERIAL > 0 WHERE    (AC_NOTE.EXPIRATION_DATE >= ENV.POSTING_DATE OR    AC_NOTE.EXPIRATION_DATE IS NULL) AND    NOTE_TYPE.DESCRIPTION IN (" + ScriptUtils.createInStatementVariables(noteDescriptions) + ") AND    AC_NOTE.PARENT_SERIAL = ?";
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            int i = 1;
            for (String noteDescription : noteDescriptions) {
                stmt.setString(i++, noteDescription);
            }
            accountSerial.set(stmt, i++);
            ResultSet rset = stmt.executeQuery();
            boolean bl = rset.next();
            return bl;
        }
    }

    public static boolean hasActiveNote(Connection conn, Serial accountSerial, Date postingDate, List<Serial> noteTypeList) throws Exception {
        if (conn == null) {
            throw new ScriptException("Null connection passed to hasActiveNote.");
        }
        if (accountSerial == null) {
            throw new ScriptException("Null account serial passed to hasActiveNote.");
        }
        if (postingDate == null) {
            throw new ScriptException("Null posting date passed to hasActiveNote.");
        }
        if (noteTypeList == null || noteTypeList.isEmpty()) {
            throw new ScriptException("Null or empty note type list passed to hasActiveNote.");
        }
        String sql = "SELECT  1 FROM  CORE.AC_NOTE WHERE  PARENT_SERIAL = ? AND  (EXPIRATION_DATE IS NULL OR   EXPIRATION_DATE >= ?) AND  TYPE_SERIAL IN (" + ScriptUtils.createInStatementVariables(noteTypeList) + ") FETCH FIRST ROW ONLY";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            int paramIndex = 0;
            accountSerial.set(stmt, ++paramIndex);
            stmt.setDate(++paramIndex, postingDate);
            for (Serial serial : noteTypeList) {
                serial.set(stmt, ++paramIndex);
            }
            boolean bl = stmt.executeQuery().next();
            return bl;
        }
    }
}

