/*
 * Decompiled with CFR 0.152.
 */
package com.corelationinc.utils;

import com.corelationinc.script.Money;
import com.corelationinc.script.Rate;
import com.corelationinc.script.ScriptException;
import com.corelationinc.script.Serial;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SQLMultiRun
implements AutoCloseable {
    Connection connection = null;
    PreparedStatement stmt = null;
    ResultSet rset = null;
    String sql = null;
    DATA_TYPE[] nextTaskDataTypes = null;
    OrderedDataCollection currentData = null;

    public SQLMultiRun(Connection connection, String sql) throws SQLException, ScriptException {
        this.stmt = connection.prepareStatement(sql);
    }

    public void run(Object ... parameters) throws SQLException, ScriptException {
        this.setParameters(this.stmt, parameters);
        this.rset = this.stmt.executeQuery();
    }

    public void run(List<Object> parameters) throws SQLException, ScriptException {
        this.setParameters(this.stmt, parameters.toArray(new Object[0]));
        this.rset = this.stmt.executeQuery();
    }

    @Override
    public void close() throws SQLException {
        if (this.stmt != null) {
            this.stmt.close();
        }
    }

    public boolean next() throws SQLException, ScriptException {
        if (!this.rset.next()) {
            this.rset.close();
            return false;
        }
        OrderedDataCollection coll = new OrderedDataCollection();
        DATA_TYPE[] dataTypes = this.getDataTypesCache(this.stmt);
        ResultMapping resultMapping = new ResultMapping(dataTypes);
        block9: for (Map.Entry entry : resultMapping.getEntrySet()) {
            int index = (Integer)entry.getKey();
            switch ((DATA_TYPE)((Object)entry.getValue())) {
                case DATE: {
                    Date date = this.rset.getDate(index);
                    coll.addDate(index, date);
                    continue block9;
                }
                case MONEY: {
                    Money money = Money.get((ResultSet)this.rset, (int)index);
                    coll.addMoney(index, money);
                    continue block9;
                }
                case SERIAL: {
                    Serial serial = Serial.get((ResultSet)this.rset, (int)index);
                    coll.addSerial(index, serial);
                    continue block9;
                }
                case STRING: {
                    String string = this.rset.getString(index);
                    coll.addString(index, string);
                    continue block9;
                }
                case RATE: {
                    Rate rate = Rate.get((ResultSet)this.rset, (int)index);
                    coll.addRate(index, rate);
                    continue block9;
                }
                case TIMESTAMP: {
                    Timestamp timestamp = this.rset.getTimestamp(index);
                    coll.addTimestamp(index, timestamp);
                    continue block9;
                }
                case LONG: {
                    long lng = this.rset.getLong(index);
                    coll.addLong(index, lng);
                    continue block9;
                }
            }
            throw new ScriptException("Attempted to create OrderedDataCollection entry for unknown type.");
        }
        this.currentData = coll;
        return true;
    }

    private OrderedDataCollection getDataCollection() {
        return this.currentData;
    }

    public Date getDate() throws ScriptException {
        return this.getDataCollection().getDate();
    }

    public Money getMoney() throws ScriptException {
        return this.getDataCollection().getMoney();
    }

    public Serial getSerial() throws ScriptException {
        return this.getDataCollection().getSerial();
    }

    public String getString() throws ScriptException {
        return this.getDataCollection().getString();
    }

    public Rate getRate() throws ScriptException {
        return this.getDataCollection().getRate();
    }

    public Timestamp getTimestamp() throws ScriptException {
        return this.getDataCollection().getTimestamp();
    }

    public Long getLong() throws ScriptException {
        return this.getDataCollection().getLong();
    }

    public int getInt() throws ScriptException {
        return this.getLong().intValue();
    }

    private DATA_TYPE[] getDataTypesCache(PreparedStatement stmt) throws SQLException {
        if (this.nextTaskDataTypes == null) {
            this.nextTaskDataTypes = this.getDataTypes(stmt);
        }
        return this.nextTaskDataTypes;
    }

    private DATA_TYPE[] getDataTypes(PreparedStatement stmt) throws SQLException {
        ResultSetMetaData meta = stmt.getMetaData();
        int columnCount = meta.getColumnCount();
        DATA_TYPE[] dataTypes = new DATA_TYPE[columnCount];
        for (int i = 1; i <= meta.getColumnCount(); ++i) {
            DATA_TYPE columnDataType;
            String columnClassName = meta.getColumnClassName(i);
            int columnScale = meta.getScale(i);
            dataTypes[i - 1] = columnDataType = SQLMultiRun.getColumnType(columnClassName, columnScale);
        }
        return dataTypes;
    }

    private void setParameters(PreparedStatement stmt, Object[] parameters) throws SQLException, ScriptException {
        int i = 1;
        for (Object parameter : parameters) {
            String className;
            switch (className = parameter.getClass().getName()) {
                case "java.math.BigDecimal": {
                    stmt.setBigDecimal(i, (BigDecimal)parameter);
                    break;
                }
                case "java.sql.Date": {
                    stmt.setDate(i, (Date)parameter);
                    break;
                }
                case "java.sql.Timestamp": {
                    stmt.setTimestamp(i, (Timestamp)parameter);
                    break;
                }
                case "java.lang.Integer": {
                    stmt.setInt(i, (Integer)parameter);
                    break;
                }
                case "java.lang.String": {
                    stmt.setString(i, (String)parameter);
                    break;
                }
                case "com.corelationinc.script.Serial": {
                    Serial serial = (Serial)parameter;
                    serial.set(stmt, i);
                    break;
                }
                case "com.corelationinc.script.Money": {
                    Money money = (Money)parameter;
                    money.set(stmt, i);
                    break;
                }
                case "com.corelationinc.script.Rate": {
                    Rate rate = (Rate)parameter;
                    rate.set(stmt, i);
                    break;
                }
                default: {
                    throw new ScriptException("Unsupported parameter type: " + className);
                }
            }
            ++i;
        }
    }

    private static DATA_TYPE getColumnType(String columnClassName, int scale) {
        switch (columnClassName) {
            case "java.math.BigDecimal": {
                return SQLMultiRun.isMoneyField(scale) ? DATA_TYPE.MONEY : DATA_TYPE.RATE;
            }
            case "java.sql.Date": {
                return DATA_TYPE.DATE;
            }
            case "java.util.Date": {
                return DATA_TYPE.DATE;
            }
            case "java.sql.Timestamp": {
                return DATA_TYPE.TIMESTAMP;
            }
            case "java.lang.Long": {
                return DATA_TYPE.LONG;
            }
        }
        return DATA_TYPE.STRING;
    }

    private static boolean isMoneyField(int scale) {
        return scale == 2;
    }

    private class ResultMapping {
        private final HashMap<Integer, DATA_TYPE> map = new HashMap();

        protected ResultMapping() {
        }

        protected ResultMapping(DATA_TYPE[] types) throws ScriptException {
            this.addMappings(types);
        }

        protected final void addMappings(DATA_TYPE[] types) throws ScriptException {
            for (int i = 0; i < types.length; ++i) {
                this.addMapping(i + 1, types[i]);
            }
        }

        protected final void addMapping(int index, DATA_TYPE type) throws ScriptException {
            if (this.map.get(index) != null) {
                throw new ScriptException("Attempted to add mapping for an existing index!");
            }
            this.map.put(index, type);
        }

        private Set<Map.Entry<Integer, DATA_TYPE>> getEntrySet() {
            return this.map.entrySet();
        }
    }

    private class OrderedDataCollection {
        private final HashMap<Integer, DataElement> map = new HashMap();
        private int iteratorIndex = 1;

        protected OrderedDataCollection() {
        }

        private void add(int index, DataElement element) throws ScriptException {
            if (this.map.get(index) != null) {
                throw new ScriptException("Attempted to add element for an existing index!");
            }
            this.map.put(index, element);
        }

        private DataElement get(int index) throws ScriptException {
            DataElement element = this.map.get(index);
            if (element == null) {
                throw new ScriptException("Attempted to get element for an index which does not exist!");
            }
            return element;
        }

        private void addDate(int index, Date date) throws ScriptException {
            DataElement element = null;
            element = date == null ? new DataElement(DATA_TYPE.DATE, "") : new DataElement(DATA_TYPE.DATE, String.valueOf(date.getTime()));
            this.add(index, element);
        }

        protected Date getDate(int index) throws ScriptException {
            DataElement element = this.get(index);
            return element.getDate();
        }

        protected Date getDate() throws ScriptException {
            return this.getDate(this.iteratorIndex++);
        }

        private void addMoney(int index, Money money) throws ScriptException {
            DataElement element = new DataElement(DATA_TYPE.MONEY, money.toKeyBridgeString());
            this.add(index, element);
        }

        protected Money getMoney(int index) throws ScriptException {
            DataElement element = this.get(index);
            return element.getMoney();
        }

        protected Money getMoney() throws ScriptException {
            return this.getMoney(this.iteratorIndex++);
        }

        private void addSerial(int index, Serial serial) throws ScriptException {
            DataElement element = new DataElement(DATA_TYPE.LONG, serial.toKeyBridgeString());
            this.add(index, element);
        }

        protected Serial getSerial(int index) throws ScriptException {
            DataElement element = this.get(index);
            return element.getSerial();
        }

        protected Serial getSerial() throws ScriptException {
            return this.getSerial(this.iteratorIndex++);
        }

        private void addString(int index, String string) throws ScriptException {
            DataElement element = new DataElement(DATA_TYPE.STRING, string);
            this.add(index, element);
        }

        protected String getString(int index) throws ScriptException {
            DataElement element = this.get(index);
            return element.getString();
        }

        protected String getString() throws ScriptException {
            return this.getString(this.iteratorIndex++);
        }

        private void addRate(int index, Rate rate) throws ScriptException {
            DataElement element = new DataElement(DATA_TYPE.RATE, rate.toKeyBridgeString());
            this.add(index, element);
        }

        protected Rate getRate(int index) throws ScriptException {
            DataElement element = this.get(index);
            return element.getRate();
        }

        protected Rate getRate() throws ScriptException {
            return this.getRate(this.iteratorIndex++);
        }

        private void addTimestamp(int index, Timestamp timestamp) throws ScriptException {
            if (timestamp == null) {
                DataElement element = new DataElement(DATA_TYPE.TIMESTAMP, "");
                this.add(index, element);
            } else {
                DataElement element = new DataElement(DATA_TYPE.TIMESTAMP, timestamp.toString());
                this.add(index, element);
            }
        }

        protected Timestamp getTimestamp(int index) throws ScriptException {
            DataElement element = this.get(index);
            return element.getTimestamp();
        }

        protected Timestamp getTimestamp() throws ScriptException {
            return this.getTimestamp(this.iteratorIndex++);
        }

        private void addLong(int index, long lng) throws ScriptException {
            DataElement element = new DataElement(DATA_TYPE.LONG, String.valueOf(lng));
            this.add(index, element);
        }

        protected long getLong(int index) throws ScriptException {
            DataElement element = this.get(index);
            return element.getLong();
        }

        protected long getLong() throws ScriptException {
            return this.getLong(this.iteratorIndex++);
        }
    }

    private class DataElement {
        DATA_TYPE type;
        String value;

        protected DataElement(DATA_TYPE type, String value) {
            this.value = value;
            this.type = type;
        }

        private Serial getSerial() throws ScriptException {
            if (this.type == DATA_TYPE.LONG) {
                Serial s = new Serial();
                s.fromString(this.value);
                return s;
            }
            throw new ScriptException("Attempted to get a Serial from a non-Serial DataElement!");
        }

        private Money getMoney() throws ScriptException {
            if (this.type == DATA_TYPE.MONEY) {
                Money money = new Money();
                money.fromString(this.value);
                return money;
            }
            throw new ScriptException("Attempted to get a Money from a non-Money DataElement!");
        }

        private Date getDate() throws ScriptException {
            if (this.type == DATA_TYPE.DATE) {
                if (this.value.isEmpty()) {
                    return null;
                }
                return new Date(Long.parseLong(this.value));
            }
            throw new ScriptException("Attempted to get a Date from a non-Date DataElement!");
        }

        private String getString() throws ScriptException {
            if (this.type == DATA_TYPE.STRING) {
                return this.value;
            }
            throw new ScriptException("Attempted to get a String from a non-String DataElement!");
        }

        private Rate getRate() throws ScriptException {
            if (this.type == DATA_TYPE.RATE) {
                return new Rate(this.value);
            }
            throw new ScriptException("Attempted to get a Rate from a non-Rate DataElement!");
        }

        private Timestamp getTimestamp() throws ScriptException {
            if (this.type == DATA_TYPE.TIMESTAMP) {
                if (this.value.isEmpty()) {
                    return null;
                }
                return Timestamp.valueOf(this.value);
            }
            throw new ScriptException("Attempted to get a Timestamp from a non-Timestamp DataElement!");
        }

        private Long getLong() throws ScriptException {
            if (this.type == DATA_TYPE.LONG) {
                return Long.parseLong(this.value);
            }
            throw new ScriptException("Attempted to get a Long from a non-Long DataElement!");
        }
    }

    private static enum DATA_TYPE {
        SERIAL,
        MONEY,
        DATE,
        STRING,
        RATE,
        TIMESTAMP,
        LONG;

    }
}

