/*
 * Decompiled with CFR 0.152.
 */
package com.corelationinc.utils;

import com.corelationinc.script.Money;
import com.corelationinc.script.Rate;
import com.corelationinc.script.Report;
import com.corelationinc.script.Script;
import com.corelationinc.script.ScriptException;
import com.corelationinc.script.Serial;
import com.corelationinc.script.Task;
import com.corelationinc.script.TaskManager;
import com.corelationinc.script.XMLSerialize;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.XMLStreamException;

public abstract class MultiThreadScript
extends TaskManager {
    protected Script script = null;
    private Connection connection = null;
    PreparedStatement stmt = null;
    ResultSet rset = null;
    private DATA_TYPE[] nextTaskDataTypes = null;
    private boolean applyTaskLimit = false;
    private int taskLimit = Integer.MAX_VALUE;
    private int currentTaskLimit = 0;
    ConcurrentHashMap<String, ReportOutput> reports;
    private Iterator<String> iteratorCache = null;
    String delimeter = null;
    List<Object> parameters = new ArrayList<Object>();
    private Date postingDate = null;

    protected final Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.script.openDatabaseConnection();
        }
        return this.connection;
    }

    protected final Date getPostingDate() throws Exception {
        return this.postingDate != null ? this.postingDate : Date.valueOf(this.script.retrievePostingDateString(this.getConnection()));
    }

    protected MultiThreadScript(Script value) {
        super(value);
        this.script = value;
    }

    public void afterTasks() throws Exception {
        this.closeAllReports();
    }

    protected final void limitTasks(int taskCount) {
        this.applyTaskLimit = true;
        this.taskLimit = taskCount;
    }

    public final Iterator<String> getArgumentIterator() {
        return this.script.getArgumentIterator();
    }

    private Iterator<String> getArgumentIteratorCache() {
        if (this.iteratorCache == null) {
            this.iteratorCache = this.getArgumentIterator();
        }
        return this.iteratorCache;
    }

    public Date getNextArgumentDate() throws ScriptException {
        Iterator<String> iterator = this.getArgumentIteratorCache();
        if (iterator == null) {
            throw new ScriptException("Insufficient number of arguments provided, please enter valid date using format 'yyyy-mm-dd'");
        }
        if (!iterator.hasNext()) {
            throw new ScriptException("Insufficient number of arguments provided, please enter valid date using format 'yyyy-mm-dd'");
        }
        String str = iterator.next();
        if (str == null || str.isEmpty()) {
            throw new ScriptException("Blank date entered, please enter valid date using format 'yyyy-mm-dd'");
        }
        Date date = null;
        try {
            date = Date.valueOf(str);
        }
        catch (IllegalArgumentException e) {
            throw new ScriptException("Invalid date entered, please enter valid date using format 'yyyy-mm-dd'");
        }
        return date;
    }

    public Rate getNextArgumentRate() throws ScriptException {
        Iterator<String> iterator = this.getArgumentIteratorCache();
        if (iterator == null) {
            throw new ScriptException("Insufficient number of arguments provided, please enter a valid rate, e.g. from 0 to 100.");
        }
        if (!iterator.hasNext()) {
            throw new ScriptException("Insufficient number of arguments provided, please enter a valid rate, e.g. from 0 to 100.");
        }
        String str = iterator.next();
        if (str == null || str.isEmpty()) {
            throw new ScriptException("Blank rate entered, please enter valid rate.");
        }
        Rate rate = null;
        try {
            rate = new Rate(str);
        }
        catch (IllegalArgumentException e) {
            throw new ScriptException("Invalid rate entered:" + str + ", please enter a valide rate, e.g.,  0 to 100.");
        }
        return rate;
    }

    public int getNextArgumentInt() throws ScriptException {
        Iterator<String> iterator = this.getArgumentIteratorCache();
        if (iterator == null) {
            throw new ScriptException("Insufficient number of arguments provided, please enter valid integer.");
        }
        if (!iterator.hasNext()) {
            throw new ScriptException("Insufficient number of arguments provided, please enter valid integer.");
        }
        String str = iterator.next();
        if (str == null || str.isEmpty()) {
            throw new ScriptException("Blank integer entered, please enter valid integer.");
        }
        try {
            int value = Integer.valueOf(str);
            return value;
        }
        catch (IllegalArgumentException e) {
            throw new ScriptException("Blank integer entered, please enter valid integer.");
        }
    }

    public String getNextArgumentString() throws ScriptException {
        Iterator<String> iterator = this.getArgumentIteratorCache();
        if (iterator == null) {
            throw new ScriptException("Insufficient number of arguments provided, please enter valid string.");
        }
        if (!iterator.hasNext()) {
            throw new ScriptException("Insufficient number of arguments provided, please enter valid string.");
        }
        String str = iterator.next();
        if (str == null || str.isEmpty()) {
            throw new ScriptException("Blank string entered, please enter valid string.");
        }
        return str;
    }

    public Money getNextArgumentMoney() throws ScriptException {
        Iterator<String> iterator = this.getArgumentIteratorCache();
        if (iterator == null) {
            throw new ScriptException("Insufficient number of arguments provided, please enter valid string.");
        }
        if (!iterator.hasNext()) {
            throw new ScriptException("Insufficient number of arguments provided, please enter valid string.");
        }
        String str = iterator.next();
        if (str == null || str.isEmpty()) {
            throw new ScriptException("Blank string entered, please enter valid string.");
        }
        try {
            Money moneyArg = new Money(str);
            return moneyArg;
        }
        catch (ScriptException e) {
            throw new ScriptException("Invalid Money argument entered: " + str + ". Please enter valid Money in the form of '0.00'.");
        }
    }

    public void setNextArgumentListDelimeter(String delimeter) {
        this.delimeter = delimeter;
    }

    public List<String> getNextArgumentStringList() throws ScriptException {
        String wholeArg = this.getNextArgumentString();
        String[] argArray = null;
        argArray = this.delimeter != null ? wholeArg.split(this.delimeter + "\\s*") : wholeArg.split(",\\s*");
        return Arrays.asList(argArray);
    }

    public List<String> getRemainingArguments() throws ScriptException {
        Iterator<String> iterator = this.getArgumentIteratorCache();
        if (iterator == null) {
            throw new ScriptException("Insufficient number of arguments provided.");
        }
        ArrayList<String> argumentList = new ArrayList<String>();
        while (iterator.hasNext()) {
            argumentList.add(iterator.next());
        }
        return argumentList;
    }

    public final Task nextTask() throws Exception {
        OrderedDataCollection data;
        if (this.applyTaskLimit) {
            if (this.currentTaskLimit >= this.taskLimit) {
                return null;
            }
            ++this.currentTaskLimit;
        }
        if ((data = this.getNextRow()) == null) {
            return null;
        }
        MultiThreadTask task = this.getTask();
        task.setDataCollection(data);
        return task;
    }

    private static boolean isCollection(Object ob) {
        if (ob == null) {
            return false;
        }
        return ob instanceof Collection;
    }

    private static boolean isArray(Object ob) {
        if (ob == null) {
            return false;
        }
        return ob.getClass().isArray();
    }

    protected final void setNextTaskParameters(Object ... objs) {
        ArrayList<Object> parametersList = new ArrayList<Object>();
        for (Object obj : objs) {
            if (MultiThreadScript.isCollection(obj)) {
                Collection c = (Collection)obj;
                for (Object o : c) {
                    parametersList.add(o);
                }
                continue;
            }
            if (MultiThreadScript.isArray(obj)) {
                Object[] arr = (Object[])obj;
                parametersList.addAll(Arrays.asList(arr));
                continue;
            }
            parametersList.add(obj);
        }
        this.parameters = parametersList;
    }

    protected final void setNextTaskParametersList(List objs) {
        this.parameters = objs;
    }

    private void setParameters(PreparedStatement stmt) throws SQLException, ScriptException {
        int i = 1;
        for (Object parameter : this.parameters) {
            String className;
            switch (className = parameter.getClass().getName()) {
                case "java.math.BigDecimal": {
                    stmt.setBigDecimal(i, (BigDecimal)parameter);
                    break;
                }
                case "java.sql.Date": {
                    stmt.setDate(i, (Date)parameter);
                    break;
                }
                case "java.util.Date": {
                    stmt.setDate(i, (Date)parameter);
                    break;
                }
                case "java.sql.Timestamp": {
                    stmt.setTimestamp(i, (Timestamp)parameter);
                    break;
                }
                case "java.lang.Integer": {
                    stmt.setInt(i, (Integer)parameter);
                    break;
                }
                case "java.lang.String": {
                    stmt.setString(i, (String)parameter);
                    break;
                }
                case "com.corelationinc.script.Serial": {
                    Serial serial = (Serial)parameter;
                    serial.set(stmt, i);
                    break;
                }
                case "com.corelationinc.script.Money": {
                    Money money = (Money)parameter;
                    money.set(stmt, i);
                    break;
                }
                case "com.corelationinc.script.Rate": {
                    Rate rate = (Rate)parameter;
                    rate.set(stmt, i);
                    break;
                }
                default: {
                    throw new ScriptException("Unsupported parameter type: " + className);
                }
            }
            ++i;
        }
    }

    protected abstract String getNextTaskSQL() throws ScriptException;

    protected abstract MultiThreadTask getTask() throws ScriptException;

    private static DATA_TYPE getColumnType(String columnClassName, int scale) {
        switch (columnClassName) {
            case "java.math.BigDecimal": {
                return MultiThreadScript.isMoneyField(scale) ? DATA_TYPE.MONEY : DATA_TYPE.RATE;
            }
            case "java.sql.Date": {
                return DATA_TYPE.DATE;
            }
            case "java.util.Date": {
                return DATA_TYPE.DATE;
            }
            case "java.sql.Timestamp": {
                return DATA_TYPE.TIMESTAMP;
            }
            case "java.lang.Long": {
                return DATA_TYPE.LONG;
            }
            case "java.lang.Integer": {
                return DATA_TYPE.LONG;
            }
        }
        return DATA_TYPE.STRING;
    }

    private static boolean isMoneyField(int scale) {
        return scale == 2;
    }

    private DATA_TYPE[] getDataTypesCache(PreparedStatement stmt) throws SQLException {
        if (this.nextTaskDataTypes == null) {
            this.nextTaskDataTypes = this.getDataTypes(stmt);
        }
        return this.nextTaskDataTypes;
    }

    private DATA_TYPE[] getDataTypes(PreparedStatement stmt) throws SQLException {
        ResultSetMetaData meta = stmt.getMetaData();
        int columnCount = meta.getColumnCount();
        DATA_TYPE[] dataTypes = new DATA_TYPE[columnCount];
        for (int i = 1; i <= meta.getColumnCount(); ++i) {
            DATA_TYPE columnDataType;
            String columnClassName = meta.getColumnClassName(i);
            int columnScale = meta.getScale(i);
            dataTypes[i - 1] = columnDataType = MultiThreadScript.getColumnType(columnClassName, columnScale);
        }
        return dataTypes;
    }

    private OrderedDataCollection getNextRow() throws SQLException, ScriptException {
        if (this.rset == null) {
            String sql = this.getNextTaskSQL();
            this.stmt = this.getConnection().prepareStatement(sql);
            this.setParameters(this.stmt);
            this.rset = this.stmt.executeQuery();
        }
        if (!this.rset.next()) {
            this.rset.close();
            this.stmt.close();
            return null;
        }
        OrderedDataCollection coll = new OrderedDataCollection();
        DATA_TYPE[] dataTypes = this.getDataTypesCache(this.stmt);
        ResultMapping resultMapping = new ResultMapping(dataTypes);
        block9: for (Map.Entry entry : resultMapping.getEntrySet()) {
            int index = (Integer)entry.getKey();
            switch ((DATA_TYPE)((Object)entry.getValue())) {
                case DATE: {
                    Date date = this.rset.getDate(index);
                    coll.addDate(index, date);
                    continue block9;
                }
                case MONEY: {
                    Money money = Money.get((ResultSet)this.rset, (int)index);
                    coll.addMoney(index, money);
                    continue block9;
                }
                case SERIAL: {
                    Serial serial = Serial.get((ResultSet)this.rset, (int)index);
                    coll.addSerial(index, serial);
                    continue block9;
                }
                case STRING: {
                    String string = this.rset.getString(index);
                    coll.addString(index, string);
                    continue block9;
                }
                case RATE: {
                    Rate rate = Rate.get((ResultSet)this.rset, (int)index);
                    coll.addRate(index, rate);
                    continue block9;
                }
                case TIMESTAMP: {
                    Timestamp timestamp = this.rset.getTimestamp(index);
                    coll.addTimestamp(index, timestamp);
                    continue block9;
                }
                case LONG: {
                    long lng = this.rset.getLong(index);
                    coll.addLong(index, lng);
                    continue block9;
                }
            }
            throw new ScriptException("Attempted to create OrderedDataCollection entry for unknown type.");
        }
        return coll;
    }

    protected final PrintStream getTextReport(String title) throws Exception {
        ReportOutput output = this.getReport(title);
        if (output == null) {
            output = this.addOutputReport(title, REPORT_TYPE.TEXT, SCRIPT_POSTING_MODE.POST);
        }
        return output.getPrintStream();
    }

    protected final XMLSerialize getXMLReport(String title) throws Exception {
        ReportOutput output = this.getReport(title);
        if (output == null) {
            output = this.addOutputReport(title, REPORT_TYPE.XML, SCRIPT_POSTING_MODE.POST);
        }
        return output.getXMLSerialize();
    }

    protected final XMLSerialize getXMLReport(String title, SCRIPT_POSTING_MODE mode) throws Exception {
        ReportOutput output = this.getReport(title);
        if (output == null) {
            output = this.addOutputReport(title, REPORT_TYPE.XML, mode);
        }
        return output.getXMLSerialize();
    }

    protected final void writeToTextReport(String title, String message) throws Exception {
        PrintStream os = this.getTextReport(title);
        os.println(message);
    }

    private ReportOutput addOutputReport(String title, REPORT_TYPE reportType, SCRIPT_POSTING_MODE postingMode) throws Exception {
        if (this.reports == null) {
            this.reports = new ConcurrentHashMap();
        }
        if (this.reports.get(title) != null) {
            throw new ScriptException("Attempted to add a report that has already exists: " + title);
        }
        ReportOutput output = new ReportOutput(title, reportType, postingMode);
        this.reports.put(title, output);
        return output;
    }

    protected final void closeReport(String title) throws ScriptException {
        if (this.reports == null) {
            throw new ScriptException("Attempted to close a report that has not been initialized: " + title);
        }
        ReportOutput output = this.getReport(title);
        if (output == null) {
            throw new ScriptException("Attempted to close a report that has not been initialized: " + title);
        }
        output.closeReport();
    }

    private ReportOutput getReport(String title) {
        ReportOutput output;
        if (this.reports == null) {
            this.reports = new ConcurrentHashMap();
        }
        if ((output = this.reports.get(title)) == null) {
            return null;
        }
        return output;
    }

    protected final void closeAllReports() throws ScriptException {
        if (this.reports == null) {
            return;
        }
        for (Map.Entry<String, ReportOutput> entry : this.reports.entrySet()) {
            entry.getValue().closeReport();
        }
    }

    protected class ReportOutput {
        String title;
        Object outputObject;
        REPORT_TYPE reportType;

        ReportOutput(String title, REPORT_TYPE type, SCRIPT_POSTING_MODE postingMode) throws Exception {
            if (type == REPORT_TYPE.XML) {
                XMLSerialize xml = this.openXMLReport(title, postingMode);
                this.outputObject = xml;
                this.reportType = type;
            } else if (type == REPORT_TYPE.TEXT) {
                PrintStream os = this.openTextReport(title);
                this.outputObject = os;
                this.reportType = type;
            }
        }

        protected XMLSerialize getXMLSerialize() throws ScriptException {
            if (this.reportType == REPORT_TYPE.XML) {
                return (XMLSerialize)this.outputObject;
            }
            throw new ScriptException("Attempted to fetch an XML report output object from a non-XML report!");
        }

        protected PrintStream getPrintStream() throws ScriptException {
            if (this.reportType == REPORT_TYPE.TEXT) {
                return (PrintStream)this.outputObject;
            }
            throw new ScriptException("Attempted to fetch a PrintStream report output object from a non-text report!");
        }

        protected Object getOuputObject() {
            return this.outputObject;
        }

        private PrintStream openTextReport(String reportTitle) throws ScriptException {
            Report report = MultiThreadScript.this.script.openReport(reportTitle, Report.Format.txt);
            report.setPostingOption(false);
            PrintStream os = new PrintStream(report.getBufferedOutputStream());
            return os;
        }

        private XMLSerialize openXMLReport(String reportTitle, SCRIPT_POSTING_MODE reportMode) throws Exception {
            Report report = MultiThreadScript.this.script.openReport(reportTitle, Report.Format.xml);
            if (reportMode == SCRIPT_POSTING_MODE.VERIFY) {
                report.setPostingOption(false);
            } else {
                report.setPostingOption(true);
            }
            XMLSerialize xml = new XMLSerialize();
            xml.setXMLWriter((OutputStream)report.getBufferedOutputStream());
            xml.putStartDocument();
            xml.putBatchQuery(MultiThreadScript.this.getPostingDate().toString());
            return xml;
        }

        private void closeReport() throws ScriptException {
            switch (this.reportType) {
                case XML: {
                    try {
                        XMLSerialize xml = this.getXMLSerialize();
                        xml.put();
                        xml.putEndDocument();
                        break;
                    }
                    catch (XMLStreamException e) {
                        throw new ScriptException("Error while closing XML Document for " + this.title + ".");
                    }
                }
                case TEXT: {
                    PrintStream os = this.getPrintStream();
                    os.close();
                    break;
                }
            }
        }
    }

    protected static enum REPORT_TYPE {
        XML,
        TEXT;

    }

    protected static enum SCRIPT_POSTING_MODE {
        VERIFY,
        POST;

    }

    class ResultMapping {
        private final HashMap<Integer, DATA_TYPE> map = new HashMap();

        protected ResultMapping() {
        }

        protected ResultMapping(DATA_TYPE[] types) throws ScriptException {
            this.addMappings(types);
        }

        protected final void addMappings(DATA_TYPE[] types) throws ScriptException {
            for (int i = 0; i < types.length; ++i) {
                this.addMapping(i + 1, types[i]);
            }
        }

        protected final void addMapping(int index, DATA_TYPE type) throws ScriptException {
            if (this.map.get(index) != null) {
                throw new ScriptException("Attempted to add mapping for an existing index!");
            }
            this.map.put(index, type);
        }

        private Set<Map.Entry<Integer, DATA_TYPE>> getEntrySet() {
            return this.map.entrySet();
        }
    }

    protected class OrderedDataCollection {
        private final HashMap<Integer, DataElement> map = new HashMap();
        private int iteratorIndex = 1;

        protected OrderedDataCollection() {
        }

        protected int getCurrentIndex() {
            return this.iteratorIndex;
        }

        private void add(int index, DataElement element) throws ScriptException {
            if (this.map.get(index) != null) {
                throw new ScriptException("Attempted to add element for an existing index!");
            }
            this.map.put(index, element);
        }

        private DataElement get(int index) throws ScriptException {
            DataElement element = this.map.get(index);
            if (element == null) {
                throw new ScriptException("Attempted to get element for an index which does not exist!");
            }
            return element;
        }

        private void addDate(int index, Date date) throws ScriptException {
            DataElement element = null;
            element = date == null ? new DataElement(DATA_TYPE.DATE, "") : new DataElement(DATA_TYPE.DATE, String.valueOf(date.getTime()));
            this.add(index, element);
        }

        protected Date getDate(int index) throws ScriptException {
            DataElement element = this.get(index);
            return element.getDate();
        }

        protected Date getDate() throws ScriptException {
            return this.getDate(this.iteratorIndex++);
        }

        private void addMoney(int index, Money money) throws ScriptException {
            DataElement element = new DataElement(DATA_TYPE.MONEY, money.toKeyBridgeString());
            this.add(index, element);
        }

        protected Money getMoney(int index) throws ScriptException {
            DataElement element = this.get(index);
            return element.getMoney();
        }

        protected Money getMoney() throws ScriptException {
            return this.getMoney(this.iteratorIndex++);
        }

        private void addSerial(int index, Serial serial) throws ScriptException {
            DataElement element = new DataElement(DATA_TYPE.LONG, serial.toKeyBridgeString());
            this.add(index, element);
        }

        protected Serial getSerial(int index) throws ScriptException {
            DataElement element = this.get(index);
            return element.getSerial();
        }

        protected Serial getSerial() throws ScriptException {
            return this.getSerial(this.iteratorIndex++);
        }

        private void addString(int index, String string) throws ScriptException {
            DataElement element = new DataElement(DATA_TYPE.STRING, string);
            this.add(index, element);
        }

        protected String getString(int index) throws ScriptException {
            DataElement element = this.get(index);
            return element.getString();
        }

        protected String getString() throws ScriptException {
            return this.getString(this.iteratorIndex++);
        }

        private void addRate(int index, Rate rate) throws ScriptException {
            DataElement element = new DataElement(DATA_TYPE.RATE, rate.toKeyBridgeString());
            this.add(index, element);
        }

        protected Rate getRate(int index) throws ScriptException {
            DataElement element = this.get(index);
            return element.getRate();
        }

        protected Rate getRate() throws ScriptException {
            return this.getRate(this.iteratorIndex++);
        }

        private void addTimestamp(int index, Timestamp timestamp) throws ScriptException {
            if (timestamp == null) {
                DataElement element = new DataElement(DATA_TYPE.TIMESTAMP, "");
                this.add(index, element);
            } else {
                DataElement element = new DataElement(DATA_TYPE.TIMESTAMP, timestamp.toString());
                this.add(index, element);
            }
        }

        protected Timestamp getTimestamp(int index) throws ScriptException {
            DataElement element = this.get(index);
            return element.getTimestamp();
        }

        protected Timestamp getTimestamp() throws ScriptException {
            return this.getTimestamp(this.iteratorIndex++);
        }

        private void addLong(int index, long lng) throws ScriptException {
            DataElement element = new DataElement(DATA_TYPE.LONG, String.valueOf(lng));
            this.add(index, element);
        }

        protected long getLong(int index) throws ScriptException {
            DataElement element = this.get(index);
            return element.getLong();
        }

        protected long getLong() throws ScriptException {
            return this.getLong(this.iteratorIndex++);
        }

        protected int getInt(int index) throws ScriptException {
            DataElement element = this.get(index);
            return element.getInt();
        }

        protected int getInt() throws ScriptException {
            return this.getInt(this.iteratorIndex++);
        }
    }

    public abstract class MultiThreadTask
    extends Task {
        private MultiThreadScript manager = null;
        private OrderedDataCollection dataCollection = null;
        private Connection taskConnection = null;
        List<PreparedStatement> statementList = new ArrayList<PreparedStatement>();

        protected Connection getConnection() throws SQLException {
            if (this.taskConnection == null) {
                this.taskConnection = this.getDatabaseConnection();
            }
            return this.taskConnection;
        }

        public MultiThreadTask(MultiThreadScript manager) {
            this.manager = manager;
        }

        private OrderedDataCollection getDataCollection() {
            return this.dataCollection;
        }

        protected void enableOutput() {
            this.setOutputEnabled(true);
        }

        protected void disableOutput() {
            this.setOutputEnabled(false);
        }

        private void setDataCollection(OrderedDataCollection coll) {
            this.dataCollection = coll;
        }

        protected Date getDate() throws ScriptException {
            return this.getDataCollection().getDate();
        }

        protected Money getMoney() throws ScriptException {
            return this.getDataCollection().getMoney();
        }

        protected Serial getSerial() throws ScriptException {
            return this.getDataCollection().getSerial();
        }

        protected String getString() throws ScriptException {
            return this.getDataCollection().getString();
        }

        protected Rate getRate() throws ScriptException {
            return this.getDataCollection().getRate();
        }

        protected Timestamp getTimestamp() throws ScriptException {
            return this.getDataCollection().getTimestamp();
        }

        protected Long getLong() throws ScriptException {
            return this.getDataCollection().getLong();
        }

        protected int getInt() throws ScriptException {
            return this.getDataCollection().getInt();
        }

        protected DATA_TYPE getType() throws ScriptException {
            return ((OrderedDataCollection)this.getDataCollection()).get((int)this.getDataCollection().getCurrentIndex()).type;
        }
    }

    private class DataElement {
        DATA_TYPE type;
        String value;

        protected DataElement(DATA_TYPE type, String value) {
            this.value = value;
            this.type = type;
        }

        private Serial getSerial() throws ScriptException {
            if (this.type == DATA_TYPE.LONG) {
                Serial s = new Serial();
                s.fromString(this.value);
                return s;
            }
            throw new ScriptException("Attempted to get a Serial from a non-Serial DataElement!");
        }

        private Money getMoney() throws ScriptException {
            if (this.type == DATA_TYPE.MONEY) {
                Money money = new Money();
                money.fromString(this.value);
                return money;
            }
            throw new ScriptException("Attempted to get a Money from a non-Money DataElement!");
        }

        private Date getDate() throws ScriptException {
            if (this.type == DATA_TYPE.DATE) {
                if (this.value.isEmpty()) {
                    return null;
                }
                return new Date(Long.parseLong(this.value));
            }
            throw new ScriptException("Attempted to get a Date from a non-Date DataElement!");
        }

        private String getString() throws ScriptException {
            if (this.type == DATA_TYPE.STRING) {
                return this.value;
            }
            throw new ScriptException("Attempted to get a String from a non-String DataElement!");
        }

        private Rate getRate() throws ScriptException {
            if (this.type == DATA_TYPE.RATE) {
                return new Rate(this.value);
            }
            throw new ScriptException("Attempted to get a Rate from a non-Rate DataElement!");
        }

        private Timestamp getTimestamp() throws ScriptException {
            if (this.type == DATA_TYPE.TIMESTAMP) {
                if (this.value.isEmpty()) {
                    return null;
                }
                return Timestamp.valueOf(this.value);
            }
            throw new ScriptException("Attempted to get a Timestamp from a non-Timestamp DataElement!");
        }

        private Long getLong() throws ScriptException {
            if (this.type == DATA_TYPE.LONG) {
                return Long.parseLong(this.value);
            }
            throw new ScriptException("Attempted to get a Long from a non-Long DataElement!");
        }

        private int getInt() throws ScriptException {
            return this.getLong().intValue();
        }
    }

    protected static enum DATA_TYPE {
        SERIAL,
        MONEY,
        DATE,
        STRING,
        RATE,
        TIMESTAMP,
        LONG;

    }
}

