/*
 * Decompiled with CFR 0.152.
 */
package com.corelationinc.script.utils.CSV;

import com.corelationinc.script.ScriptException;
import com.corelationinc.script.utils.CSV.CSVResultRow;
import java.sql.ResultSet;
import java.util.Objects;

public class TabWriter {
    public static String printAsCsvRow(CSVResultRow row) {
        String newRow = "";
        while (row.next()) {
            newRow = newRow + TabWriter.formatToTabData(row.getCurrentValue(), row.isLastValue());
        }
        return newRow;
    }

    public static String formatToTabData(String oldData, boolean isLastCol) {
        String newData = "";
        if (oldData == null || oldData.isEmpty()) {
            if (isLastCol) {
                return newData;
            }
            return newData + "|";
        }
        newData = oldData;
        if (newData.contains("\"")) {
            newData = newData.replace("\"", "\"\"");
        }
        if (newData.contains("|")) {
            newData = "\"" + newData + "\"";
        }
        if (!isLastCol) {
            newData = newData + "|";
        }
        return newData;
    }

    public static String formatToTabData(String oldData) {
        String newData = "";
        if (oldData == null || oldData.isEmpty()) {
            return newData + "|";
        }
        newData = oldData;
        if (newData.contains("\"")) {
            newData = newData.replace("\"", "\"\"");
        }
        if (newData.contains("|")) {
            newData = "\"" + newData + "\"";
        }
        return newData + "|";
    }

    public static String formatToTabData(ResultSet rset) throws Exception {
        String csvRow = "";
        for (int i = 1; i <= rset.getMetaData().getColumnCount(); ++i) {
            csvRow = csvRow + TabWriter.formatToTabData(rset.getString(i));
        }
        return csvRow.substring(0, csvRow.length() - 1);
    }

    public static String formatToTabData(String ... values) {
        if (values == null || values.length == 0) {
            return "";
        }
        String output = "";
        for (String value : values) {
            output = output + TabWriter.formatToTabData(value, false);
        }
        if (output.length() == 0) {
            return "";
        }
        return output.substring(0, output.length() - 1);
    }

    public static String formatToCsvData(Objects ... objs) throws ScriptException {
        if (objs == null || objs.length == 0) {
            return "";
        }
        String row = "";
        for (Objects obj : objs) {
            row = obj == null ? row + TabWriter.formatToTabData(" ", false) : row + TabWriter.formatToTabData(obj.toString(), false);
        }
        return row.substring(0, row.length() - 1);
    }
}

