/*
 * Decompiled with CFR 0.152.
 */
package com.corelationinc.script.utils.CSV;

import com.corelationinc.script.ScriptException;
import com.corelationinc.script.utils.CSV.CSVResultRow;
import java.sql.ResultSet;
import java.util.Objects;

public class CSVWriter {
    public static String printAsCsvRow(CSVResultRow row) {
        String newRow = "";
        while (row.next()) {
            newRow = newRow + CSVWriter.formatToCSVData(row.getCurrentValue(), row.isLastValue());
        }
        return newRow;
    }

    public static String formatToCSVData(String oldData, boolean isLastCol) {
        String newData = "";
        if (oldData == null || oldData.isEmpty()) {
            if (isLastCol) {
                return newData;
            }
            return newData + ",";
        }
        newData = oldData;
        if (newData.contains("\"")) {
            newData = newData.replace("\"", "\"\"");
        }
        if (newData.contains(",")) {
            newData = "\"" + newData + "\"";
        }
        if (!isLastCol) {
            newData = newData + ",";
        }
        return newData;
    }

    public static String formatToCSVData(String oldData) {
        String newData = "";
        if (oldData == null || oldData.isEmpty()) {
            return newData + ",";
        }
        newData = oldData;
        if (newData.contains("\"")) {
            newData = newData.replace("\"", "\"\"");
        }
        if (newData.contains(",")) {
            newData = "\"" + newData + "\"";
        }
        return newData + ",";
    }

    public static String formatToCSVData(ResultSet rset) throws Exception {
        String csvRow = "";
        for (int i = 1; i <= rset.getMetaData().getColumnCount(); ++i) {
            csvRow = csvRow + CSVWriter.formatToCSVData(rset.getString(i));
        }
        return csvRow.substring(0, csvRow.length() - 1);
    }

    public static String formatToCSVData(String ... values) {
        if (values == null || values.length == 0) {
            return "";
        }
        String output = "";
        for (String value : values) {
            output = output + CSVWriter.formatToCSVData(value, false);
        }
        if (output.length() == 0) {
            return "";
        }
        return output.substring(0, output.length() - 1);
    }

    public static String formatToCsvData(Objects ... objs) throws ScriptException {
        if (objs == null || objs.length == 0) {
            return "";
        }
        String row = "";
        for (Objects obj : objs) {
            row = obj == null ? row + CSVWriter.formatToCSVData(" ", false) : row + CSVWriter.formatToCSVData(obj.toString(), false);
        }
        return row.substring(0, row.length() - 1);
    }
}

