/*
 * Decompiled with CFR 0.152.
 */
package com.corelationinc.script.utils.CSV;

import com.corelationinc.script.Money;
import com.corelationinc.script.Option;
import com.corelationinc.script.Rate;
import com.corelationinc.script.Serial;
import com.corelationinc.script.utils.CSV.CSVResultRow;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;

public class CSVResultSet {
    private ArrayList<String> columnHeaders;
    private LinkedList<CSVResultRow> resultRowList = new LinkedList();
    int rowIndex = -1;
    private CSVResultRow currentRow = null;

    public boolean next() {
        if (this.rowIndex == -1) {
            if (!this.resultRowList.isEmpty()) {
                ++this.rowIndex;
                if (!this.getColumnHeaders().isEmpty()) {
                    ++this.rowIndex;
                }
                this.currentRow = this.resultRowList.get(this.rowIndex);
                return this.currentRow.next();
            }
            return false;
        }
        if (this.rowIndex == this.resultRowList.size() - 1) {
            return false;
        }
        ++this.rowIndex;
        this.currentRow = this.resultRowList.get(this.rowIndex);
        return this.currentRow.next();
    }

    public void addResultRow(CSVResultRow resultRow) {
        if (this.resultRowList == null) {
            this.resultRowList = new LinkedList();
        }
        this.resultRowList.add(resultRow);
    }

    public ArrayList<String> getColumnHeaders() {
        return this.columnHeaders;
    }

    public int getCurrentRowSize() {
        return this.currentRow.getRowSize();
    }

    public String getColumnHeader(int index) {
        return this.columnHeaders.get(index);
    }

    public int getColumnIndex(String header) {
        return this.columnHeaders.indexOf(header);
    }

    public String getString() {
        return this.currentRow.getCurrentValue();
    }

    public String getString(int index) {
        return this.currentRow.getValue(index);
    }

    public String getString(String header) {
        int index = this.columnHeaders.indexOf(header);
        return this.currentRow.getValue(index);
    }

    public int getInt() {
        return Integer.parseInt(this.getString());
    }

    public int getInt(int index) {
        return Integer.parseInt(this.getString(index));
    }

    public int getInt(String header) {
        return Integer.parseInt(this.getString(header));
    }

    public Money getMoney() {
        Money tempVal = new Money();
        tempVal.fromString(this.getString());
        return tempVal;
    }

    public Money getMoney(int index) {
        Money tempVal = new Money();
        tempVal.fromString(this.getString(index));
        return tempVal;
    }

    public Money getMoney(String header) {
        Money tempVal = new Money();
        tempVal.fromString(this.getString(header));
        return tempVal;
    }

    public Serial getSerial() {
        Serial tempVal = new Serial();
        tempVal.fromString(this.getString());
        return tempVal;
    }

    public Serial getSerial(int index) {
        Serial tempVal = new Serial();
        tempVal.fromString(this.getString(index));
        return tempVal;
    }

    public Serial getSerial(String header) {
        Serial tempVal = new Serial();
        tempVal.fromString(this.getString(header));
        return tempVal;
    }

    public Option getOption() {
        Option tempVal = new Option();
        tempVal.fromString(this.getString());
        return tempVal;
    }

    public Option getOption(int index) {
        Option tempVal = new Option();
        tempVal.fromString(this.getString(index));
        return tempVal;
    }

    public Option getOption(String header) {
        Option tempVal = new Option();
        tempVal.fromString(this.getString(header));
        return tempVal;
    }

    public Rate getRate() {
        Rate tempVal = new Rate();
        tempVal.fromString(this.getString());
        return tempVal;
    }

    public Rate getRate(int index) {
        Rate tempVal = new Rate();
        tempVal.fromString(this.getString(index));
        return tempVal;
    }

    public Rate getRate(String header) {
        Rate tempVal = new Rate();
        tempVal.fromString(this.getString(header));
        return tempVal;
    }

    public Date getDate() {
        return Date.valueOf(this.getString());
    }

    public Date getDate(int index) {
        return Date.valueOf(this.getString(index));
    }

    public Date getDate(String header) {
        return Date.valueOf(this.getString(header));
    }

    public Timestamp getTimestamp() {
        return Timestamp.valueOf(this.getString());
    }

    public Timestamp getTimestamp(int index) {
        return Timestamp.valueOf(this.getString(index));
    }

    public Timestamp getTimestamp(String header) {
        return Timestamp.valueOf(this.getString(header));
    }

    public boolean getBoolean() {
        return this.isTrueExpression(this.getString().toUpperCase());
    }

    public boolean getBoolean(int index) {
        return this.isTrueExpression(this.getString(index).toUpperCase());
    }

    public boolean getBoolean(String header) {
        return this.isTrueExpression(this.getString(header).toUpperCase());
    }

    private boolean isTrueExpression(String boolExp) {
        if (boolExp != null && !boolExp.isEmpty()) {
            return boolExp.equals("1") || boolExp.equals("Y") || boolExp.equals("YES") || boolExp.equals("T") || boolExp.equals("TRUE");
        }
        return false;
    }

    public CSVResultRow getCurrentRow() {
        return this.currentRow;
    }

    public LinkedHashMap<String, String> getCurrentRowAsMap() {
        LinkedHashMap<String, String> currRowMap = new LinkedHashMap<String, String>();
        for (String header : this.columnHeaders) {
            currRowMap.put(header, this.getString(header));
        }
        return currRowMap;
    }

    public void setColumnHeaders(String[] tokens) {
        this.columnHeaders = new ArrayList<String>(Arrays.asList(tokens));
    }
}

