/*
 * Decompiled with CFR 0.152.
 */
package com.corelationinc.script.utils.CSV;

import com.corelationinc.script.ScriptException;
import com.corelationinc.script.utils.CSV.CSVResultRow;
import com.corelationinc.script.utils.CSV.CSVResultSet;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class CSVResultReader {
    public static CSVResultSet readCsvData(String filePath) throws Exception {
        return CSVResultReader.readCsvData(filePath, DELIMITER.COMMA, true, 0, true);
    }

    public static CSVResultSet readCsvData(String filePath, boolean hasHeaderRow) throws Exception {
        return CSVResultReader.readCsvData(filePath, DELIMITER.COMMA, hasHeaderRow, 0, true);
    }

    public static CSVResultSet readCsvData(String filePath, DELIMITER delim) throws Exception {
        return CSVResultReader.readCsvData(filePath, delim, true, 0, true);
    }

    public static CSVResultSet readCsvData(String filePath, int rowSkipCount) throws Exception {
        return CSVResultReader.readCsvData(filePath, DELIMITER.COMMA, true, rowSkipCount, true);
    }

    public static CSVResultSet readCsvData(String filePath, DELIMITER delim, boolean hasHeaderRow) throws Exception {
        return CSVResultReader.readCsvData(filePath, delim, hasHeaderRow, 0, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CSVResultSet readCsvData(String filePath, DELIMITER delim, boolean hasHeaderRow, int rowSkipCount, boolean utf8Validation) throws ScriptException {
        CSVResultSet csvRset = new CSVResultSet();
        String regExSplit = CSVResultReader.getRegexExpression(delim);
        BufferedReader bfr = null;
        int rowNumber = 0;
        try {
            try {
                bfr = new BufferedReader(new FileReader(filePath));
            }
            catch (FileNotFoundException ex) {
                throw new ScriptException("File not found: " + filePath);
            }
            if (bfr == null) {
                throw new ScriptException("Bad Filepath name: " + filePath);
            }
            String line = CSVResultReader.getNextLine(bfr);
            while (line != null) {
                if (rowNumber < rowSkipCount) {
                    ++rowNumber;
                    continue;
                }
                if (line.length() <= 0 || line.trim().isEmpty()) continue;
                String[] tokens = line.split(regExSplit, -1);
                System.out.println("Token length: " + tokens.length);
                CSVResultRow csvRow = new CSVResultRow(rowNumber);
                if (hasHeaderRow) {
                    csvRset.setColumnHeaders(tokens);
                    hasHeaderRow = false;
                } else {
                    int colIndex = 0;
                    for (String token : tokens) {
                        csvRow.addCsvValue(CSVResultReader.getColData(token, utf8Validation), colIndex);
                        ++colIndex;
                    }
                }
                csvRset.addResultRow(csvRow);
                line = CSVResultReader.getNextLine(bfr);
            }
        }
        finally {
            try {
                bfr.close();
            }
            catch (Exception e) {
                throw new ScriptException(filePath, (Throwable)e);
            }
        }
        return csvRset;
    }

    private static String getNextLine(BufferedReader bfr) throws ScriptException {
        try {
            return bfr.readLine();
        }
        catch (IOException ex) {
            throw new ScriptException("Error reading file");
        }
    }

    private static String getColData(String token, boolean utf8Validation) {
        if (token == null || token.isEmpty()) {
            return "";
        }
        String newValue = token;
        if (utf8Validation) {
            StringBuilder utf8Line = new StringBuilder();
            for (char ch : token.toCharArray()) {
                char asciiDec = ch;
                if (asciiDec > '\u0000' && asciiDec < '\u0080') {
                    utf8Line.append(ch);
                    continue;
                }
                utf8Line.append("~");
            }
            newValue = utf8Line.toString();
        }
        if (newValue.startsWith("\"") && newValue.endsWith("\"")) {
            newValue = newValue.substring(1, newValue.length() - 1);
        }
        return newValue;
    }

    private static String getRegexExpression(DELIMITER delim) {
        switch (delim) {
            case COMMA: {
                return ",(?=([^\"]*\"[^\"]*\")*[^\"]*$)";
            }
            case PIPE: {
                return "\\|(?=([^\"]*\"[^\"]*\")*[^\"]*$)";
            }
            case TAB: {
                return "\t(?=([^\"]*\"[^\"]*\")*[^\"]*$)";
            }
        }
        return ",(?=([^\"]*\"[^\"]*\")*[^\"]*$)";
    }

    public static enum DELIMITER {
        COMMA,
        PIPE,
        TAB;

    }
}

